"Macro Data Sheet file v. 1" 
gamesystem GURPS 
title "GURPS Compendium I (v. 3.0.0)"
version 253
level 3

copyright "Copyright  1986-2001 Steve Jackson Games Incorporated. All rights reserved. \
GURPS is a registered trademark of Steve Jackson Games Incorporated."

$$define PLUGIN CI

logo gurps/CompendiumI.lgo

$$include gurps.inc

define

func multformavg(d) "{\r\n\
local number, t, i, cost, name, nopts;\r\n\
t = total;\r\n\
number = 1;\r\n\
i = 1;\r\n\
nopts = optCount('File Name');\r\n\
while (i <= nopts)\r\n\
  name = optValue('File Name', i);\r\n\
  if (strlen(name) > 0)\r\n\
	cost = getFileValue(name, 'total');\r\n\
	t = t + cost;\r\n\
	number = number + 1;\r\n\
  endif\r\n\
  i = i + 1;\r\n\
endwhile\r\n\
return round (t/number);\r\n\
}"

end


# Racial height/weight macro.

$$macro rhw(name, defValue, mult, disp)
{{
	item "Racial $(name)"
		prereq "!#1,Advantages:Racial $(name);!Racial Height and Weight"
		cat "Racial $(name)"
		format "%0ln ($(disp))"
		formula "0*sex*st$$ifdef(mult)*$(mult)$$endif"
		varname vRacial$(name)
		sformat %0ln
		checkexp 1 # Required to force reevaluation when ST changes.

		editdlg 2
		adj "racial$(name)=`$(name)`"
		opt
			begin exp "$(name)" "round($(defValue))*(`Percentage`/100))" noprint keepold end
			begin text Percentage 100 keepold end
			end
}}


# Macro for werecreatures.

$$macro were(name, cost, st, dx, ht, pd, dr, spd, att, weight, size, cat, adj, autoitems, hitpoints, req)
{{
	$$if(adj!='' or req!='')
		$$if(adj!='' and req!='')
			$$cadv($(name), $(cost), "!#1,Adv:Shapeshifter~$(req)", "Occult/Paranormal;Shapeshifter;$(cat)", ,  "Adv:Regeneration+1;$(adj)")
		$$else
			$$ifdef(adj)
				$$cadv($(name), $(cost), "!#1,Adv:Shapeshifter", "Occult/Paranormal;Shapeshifter;$(cat)", ,  "Adv:Regeneration+1;$(adj)")
			$$endif
			$$ifdef(req)
				$$cadv($(name), $(cost), "!#1,Adv:Shapeshifter~$(req)", "Occult/Paranormal;Shapeshifter;$(cat)", ,  "Adv:Regeneration+1")
			$$endif
		$$endif
	$$else
		$$cadv($(name), $(cost), "!#1,Adv:Shapeshifter", "Occult/Paranormal;Shapeshifter;$(cat)", ,  "Adv:Regeneration+1")
	$$endif
	size 302 350
	deleteauto dontmarkauto autochargecost noautodup
	autoitems "Regeneration;$(autoitems)"
	opt
		add "Deliberate Change" "?+0;+5"
		$$ifdef(st)
			exp ST "$(st)"
		$$endif
		$$ifdef(dx)
			exp DX "$(dx)"
		$$endif
		$$ifdef(ht)
			exp HT "$(ht)"
		$$endif
		$$ifdef(hitpoints)
			exp "Hit Points" "$(hitpoints)"
		$$endif
		$$ifdef(PD)
			text PD "$(PD)"
		$$endif
		$$ifdef(DR)
			text DR "$(DR)"
		$$endif
		text Speed "$(spd)"
		exp Damage "$(att)"
		$$ifdef(weight)
			exp Weight "dw($(weight))"
		$$endif
		text Size "$(size)"
		end
}}

$$macro csp(name) {{
	$$ladv($(name), 5, , , "x>0 and x<=20", , College Skill)
}}


cat "Additional Attributes" 
	# Put invocations of the deriv and custAttr macro here.
	$$deriv("Alcohol Tolerance", "HT*sex*alcoholTolerance*0", "round(HT*2*(sex=2?0.6:1)+alcoholTolerance)", AlTol)
	$$deriv("Stun", "x_ht*x_stun*0", "x_ht*5+x_stun", Stun)
	sublist "Senses" memlist
		$$sense(Faz, faz)
		end
	end

cat "Advantages"
	sublist "Mundane Advantages" memlist
		$$zcadv("Acceleration Tolerance", 10)
		$$ladv("Acute Faz", 2, faz+x, , , Faz Sense, *Acute Sense, , , , +^v)
			opt	exp "Faz" "fazSense?fazSense:iq+faz"
				end
		$$ladv("Administrative Rank", 5, , , "x>=1 and x<=6")
		$$zcadv("Alcohol Tolerance", 5, , , , "alcoholTolerance+5", , , , vAlcoholTolerance)
		$$ladv("Ally (Unwilling)", 5, , , , , , , "%0ln (^o'Points' points, ^o'Frequency')%-14rc%-7r!")
			dupexpected
			opt
				begin exp "Points" "(x-1)*50+125" noprint end
				begin mult "Frequency" "?:2;6 or less,׽;9 or less,1;12 or less,2;15 or less,3" noprint end
				end
		$$cadv("Autotrance", 5)
		$$cadv("Bardic Immunity", 10, "Sk:Bardic Lore>=iq-2|Sk:Skaldic Lore>=iq-2")
		$$cadv("Beast-Kin", 15, , , , "Sk:Animal+4;BeastKin+1")
		$$ladv("Breath-Holding", 2)
		$$cadv("Chronolocation", 15)
	
		$$ladv("Claim to Hospitality", 1, , , x>0 and x<=10, , , , %0ln%-14rc%-7r!)
		$$cadv("Cool", 1, , , , fright+1)
			opt exp "Fright Check" willpower+fright end
		$$ladv("Courtesy Rank", 1)
		$$cadv("Cultural Adaptability", 25, , , , "Sk:Social+1;Adv:Charisma+1;\"Adv:Language Talent\"+2")
			noautodup dontmarkauto autochargecost
			autoitems "Charisma=1;Language Talent=2"
		sublist "Ultra-Tech" memlist
			$$zcadv("Interface Jack", 10, "Configuration:TL>=8-&tl")
			$$cadv("Interface Talent", 5, "Configuration:TL>=8-&tl")
			$$cadv("Mechanical Telepathy", 120, "Configuration:TL>=9-&tl")
			$$nadv("Neural Cyberdeck Interface", , "$Marquee Interface;1;Icon Interface;2;Environmental Interface;3", 
				"15+x*5", x>0 and x<30, "Configuration:TL>=8-&tl")
				opt
					begin percent "Obsolescence" "?:1;State-of-the-Art,+0%;One Generation Behind,-50%;Two Generations Behind,-75%" end
					end
			$$nadv("Panimmunity", , "$TL9;1;TL10;2;TL12;3", "qindex(x,2,5,10)", x>0 and x<=3, "Configuration:TL>=9-&tl")
			$$ladv("Sensie Talent", 2, "\"Skills:Sensie Interface\"+x", , , "Configuration:TL>=8-&tl")
			end
		$$cadv("Daredevil", 15)
		$$zcadv("Deep Sleeper", 5)
		$$cadv("Diplomatic Immunity", 20)
		$$zcadv("Disease-Resistant", 5)

		$$cadv	Enhanced Block	6				b_block+1
		$$cadv	Enhanced Dodge	15				b_dodge+1
		$$cadv	Enhanced Parry (All Weapons)	10				b_awparry+1
		$$cadv	Enhanced Parry (Bare Hands)	6				b_bhparry+1
		$$cadv(Enhanced Parry, 6, , , , b_1wparry+0, "^n (^o'Skill')", "%0ln (^o'Skill')%-5rc")
			opt
				begin text Skill "Weapon Skill" keepold noprint end
				end

		$$cadv("Fashion Sense", 5)
			opt exp Reaction format('%+d',1) end
		$$nadv("Fit", , "$Standard;1;Very;2", x=1?5:15, x=1 or x=2, , , , "%0ln^x|@v@>1?format(' (%s)', itemInfo('@level@')):''|%-14rc%-7r!")
			opt	exp "HT" "format('+%d',x)"
				exp "Fatigue Loss" "x=1?'Normal':'Half'"
				text "Fatigue Recovery" "Double Rate"
				end
		$$nadv("Gadgeteer", , "$Realistic;1;Cinematic;2", x*25, x=1 or x=2)
		$$cadv("G-Experience", 10)
		$$cadv("Heir", 5)
		$$ladv("High Technology", Variable, tl+x, "qindex(x,20,50,100)", "x>0 and x<=3", !Disadv:Primitive)
			opt
				exp "Effective TL" tl+&tl
				end
		$$cadv("Higher Purpose", 5)
		$$nadv("Immunity to Timesickness", , "$Nuisance;1;Mild;2;Severe;3;Very Severe;4;Nightmare;5;Critical;6",
			"qindex(x,2,5,10,15,15,20)", x>0 and x<=6, , , , , "round((c+a)*m)-`Campaign Default`")
			opt
				begin mult "Frequency" "?:2;Rare,1/2;Frequent,1;Very Frequent,1.5;Acute,2" end
				begin text "Campaign Default" ??0 noprint keepold end
				end
		$$cadv("Imperturbable", 10, , , , fright+5)
			opt exp "Fright Check" willpower+fright end
		$$nadv("Improved G-Tolerance", , "$0.3 G Increment;1;0.5 G Increment;2;1 G Increment;3;5 G Increment;4;10 G Increment;5",
			x*5, x>0 and x<=5, !Disadv:G-Intolerance)
		$$ladv("Increased Speed", 25, b_speed+x, , , , , , , , +^v)
		$$cadv("Intuitive Mathematician", 25, , , , "\"Adv:Lightning Calculator\"+1;\"Adv:Mathematical Ability\"+1")
			textline noautodup dontmarkauto autochargecost
			textline autoitems "Lightning Calculator;Mathematical Ability"
		$$ladv("Less Sleep", 3, , , "x>=1 and x<=5")
			opt	exp "Sleep" "format('%d hour%s', -x, x=1?'':'s')"
				end
		$$cadv("Light Hangover", 2)
		$$ladv("Manual Dexterity", 3, Sk:Manual+x)
		$$cadv("No Hangover", 5)
		$$cadv("Pious", 5)
			opt exp Reaction format('%+d',1) end
		$$cadv("Pitiable", 5, , , , "Sk:panhandling+3")
			opt exp Reaction format('%+d',3) end
		$$cadv("Plant Empathy", 5, , , , "Sk:Agronomy+4;Sk:Botany+2")
		$$ladv("Rank", 5)
		$$zcadv("Resistant to Poison", 5)
		$$cadv("Sanctity", 5)
		$$nadv("Security Clearance", , "$Nation;1;Corporation;2;World Power;3;Megacorporation;4",
				"qindex(x,2,2,5,5)", x>0 and x<=4)
			textline dupexpected
			opt mult "Level" 1
				end
		$$cadv("Sensitive", 5)
		$$nadv("Serendipity", , "$Once per Session;1;Twice per Session;2", x*15, x=1 or x=2)
		$$cadv("Single-Minded", 5)
		$$ladv("Temperature Tolerance", 1, , , , , , temperaturetolerance)
			opt	text "Zone Center" "??63;63;x"
				exp "Min. Temperature" "`Zone Center`-28-ht/2*x"
				exp "Max. Temperature" "`Zone Center`+27+ht/2*x"
				end
		$$cadv("Tenure", 5)
		$$cadv("3D Spatial Sense", 10, , , , "Sk:Flight+2;Sk:astrogation+2;Sk:Piloting+1;Sk:freefall+2;Sk:bodysense+3")
		$$cadv("Tree-Kin", 15, , , , "Sk:agronomy+4;Sk:botany+4;TreeKin+1")
		# +1 to Plant spells is close, but not quite right (it's right for
		# Hard spells, but Very Hard are learned as if they were Hard)
		$$cadv("Versatile", 5)
		$$zcadv("Very Fit", 15)
			opt	text "HT" "+2"
				text "Fatigue Loss" "Half"
				text "Fatigue Recovery" "Double Rate"
				end
		$$zcadv("Very Rapid Healing", 15, "Main:HT>=12")
		end
	sublist "Cinematic" memlist
		$$ladv("Extra Stun", 2, "x_stun+x")
			opt 
				begin mult "Extra HP" "?:2;Extra Hit Points Allowed,1/4;No Extra Hit Points,1" end
				end
		$$cadv("Rapier Wit", 5)
		end
	sublist "Occult and Paranormal Advantages" memlist
		$$ladv("Animal Form", 100/form)
		$$nadv("Awareness", , "$Detect Paranormal;1;See Auras;2", "15+(x-1)*20", x=1 or x=2, , Occult/Paranormal)
		$$cadv("Channelling", 10, , Occult/Paranormal)
		$$nadv("Clerical Magic", "b_spells+`Spell Bonus`/5;Sp:Healing+`Healing Bonus`/2",
			"$One College;1;Two Colleges;2;Three Colleges;3", "qindex(x,10,12,15)", x>0 and x<=3,
			"Adv:Clerical Investment", Magery;Occult/Paranormal)
			opt 
				add "Spell Bonus" "??0;0;x*5;x>=0 and x<=3"
				add "Healing Bonus" "??0;0;x*2;x>=0 and x<=3"
				add "Other Abilities" "??0;0;x*5;x>=0"
				end
		$$cadv("Divination Talent", 5, , Magery;Occult/Paranormal)
		$$nadv("Divine Favor", , "$Deity;1;Lesser Deity;2", x=1?25:20, x=1 or x=2, , Occult/Paranormal)
			opt 
				mult "Appears" "?:2;Quite rarely (6-),1/2;Fairly often (9-),1;Quite often (12-),2;Almost all the time (15-),3"
				add "Reaction Bonus" "??+0;0;x*5"
				end
		$$ladv("Extra Life", 25/life, , , , "!Adv:Resurrection", Occult/Paranormal)
		$$cadv("Faerie Empathy", 10, , Occult/Paranormal)
		$$cadv("Faith Healing", 30, , Occult/Paranormal)
		$$cadv("Familiar", 0, "#1,Adv:Magery>=2", Occult/Paranormal;Familiar;Familiar Powers, , , , %0ln)
			addaslist
		sublist "Familiar Advantages" memlist
			$$cadv(See Through Familiar's Eyes, 5, "#1,Adv:Magery>=2", Occult/Paranormal;Familiar)
			$$ladv(Familiar ST Source, 3, , , , "#1,Adv:Magery>=2", Occult/Paranormal;Familiar, , , , , "tcfunc(c,a,@mo@*(itemInfo('`Limited Range`')?2:1),@p@)")
			$$ladv("Take Familiar's Shape", 5, , , x>0 and x<=4, "#1,Adv:Magery>=2", Occult/Paranormal;Familiar)
			$$ladv(Intelligent Familiar, Variable, , "itemInfo('`Demonic Familiar`')?qindex(x-6,-5,-15,-25,-35):5+(x-7)*10", x>6, 
				"#1,Adv:Magery>=2", Familiar;Occult/Paranormal, , ,
				7, , c)
				opt
					begin text "Demonic Familiar" ?+0; dispexp 'l' noprint end
					end
			$$cadv("Speaking Familiar (Mental Communication)", 5, "#1,Adv:Magery>=2", Occult/Paranormal;Familiar)
			$$cadv("Speaking Familiar (Actual Speech)", 10, "#1,Adv:Magery>=2;Intelligent Familiar>=7", Occult/Paranormal;Familiar)
			$$cadv(Familiar Has Nine Lives, 5, "#1,Adv:Magery>=2", Occult/Paranormal;Familiar)
			$$cadv(Suffer Familiar's Wounds, -15, "#1,Adv:Magery>=2", Occult/Paranormal;Familiar)
			end
		$$cadv("Fugue", 50, , Occult/Paranormal)
		$$cadv("Illuminated", 60, , Occult/Paranormal, , "Adv:Luck+2;Adv:Intuition+1")
			textline noautodup dontmarkauto autochargecost
			textline autoitems "Luck=2;Intuition"
		$$ladv("Knack", "2%/cost", , "ceil(x*optValue('Percentage')/100)", , , Occult/Paranormal)
			opt
				begin text Percentage "??2;2;x;x>0" noprint dispexp "'l: o%'" end
				mult "Normally requires Magery" "?+0;2"
				mult "No Need to Touch Subject" "?+0;2"
				end
		$$cadv("Lunar Influence", 5, , Occult/Paranormal)
		$$ladv("Mana Damper", 5, , , , "!#1,Magery;!#1,Spells::May not learn spells.;!Mana Enhancer", Occult/Paranormal, , "%0ln (^o'Radius', ^x|optTextValue('Reduce')|)%-14rc%-7rv")
			opt 
				begin exp "Radius" "x<=1?'Touch':format('%d hex%s',x-1,x>2?'es':'')"
					end
				begin percent "Reduce" "?:1;One Step,+0%;Two Steps,+100%;Three Steps,+200%"
					end
				percent "Switchable" "?+0;+100%"
				end
		$$ladv("Mana Enhancer", 25, , , , "!Mana Damper;!Adv:Magic Resistance", Occult/Paranormal, , "%0ln (^o'Radius', ^x|optTextValue('Increase')|)%-14rc%-7rv")
			opt 
				begin exp "Radius" "x<=1?'Touch':format('%d hex%s',x-1,x>2?'es':'')"
					end
				begin percent "Increase" "?:1;One Step,+0%;Two Steps,+100%;Three Steps,+200%"
					end
				percent "Switchable" "?+0;+100%"
				end
		$$cadv("Medium", 10, , Occult/Paranormal)
		$$ladv("Mindlink", 1, , , , , Occult/Paranormal)
		$$cadv("Natural Spellcasting", 15, "#1,Adv:Magery>=1", Occult/Paranormal)
			opt	exp "First-Time Casting Level" "format('%d (%d VH)',iq+magery-6,iq+magery-7)"
				end
		$$cadv("Non-Reciprocal Damage", 30, "Animal Form|Multiple Forms|#1,Adv:Shapeshifter|Transformation", Occult/Paranormal)
		$$cadv("Oracle", 15, , Occult/Paranormal)
		$$ladv("Power Investiture", 10, "b_spells+x", , , , Magery;Occult/Paranormal)
		$$ladv("Psionic Resistance", 2, , , , , Occult/Paranormal)
		$$nadv("Racial Memory", , "$Passive;1;Active;2", x=1?15:40, x=1 or x=2, , Occult/Paranormal)
		$$cadv("Reawakened", 10, , Occult/Paranormal)
		$$cadv("Reciprocal Rest", 15, "Animal Form|Multiple Forms|Shapeshifter|Transformation", Occult/Paranormal)
		$$cadv("Retrogression", 40, , Occult/Paranormal)
		$$ladv("Second Sight", Variable, , "x+(magery>=1?2:5)", x>=0, , Occult/Paranormal, SecondSight, "%0ln%-14rc%-7r!", 0)
			editdlg 4
		$$cadv(Unaging, 15, "!#1,Advantages:Unaging;!Disadv:Age", Occult/Paranormal;Unaging, , NoAging+1)
			opt
				percent "Age Either Direction" ?+0;+20%
				end
		sublist "Weres" memlist
			$$were(Werebear, 15, ST*2, 13, HT+2, 1, 4, 8, "format('bite: cut %s, claws: cr %s', thrust(`st`,0), thrust(`st`,0))",
				bodyweight*4, "2 (1 when standing)", Aggressive, Disadv:Berserk+1, "?list:Disadv;Disadvantages:Berserk")
			$$were("Wereboar", 25, ST*2, 14, HT+2, 1, 3, 8, "format('tasks: cut %s, trampling: cr 1d-1', thrust(`st`,0))",
				bodyweight*3, 2)
			$$were("Werebull", 30, ST*3, 10, HT+2, 1, 1, 8, "format('charge: imp %s, trample: cr 1d+1', thrust(`st`,0))",
				bodyweight*5, 2, , , , , "Disadv:Bad Temper|Disadv:Berserk")
			$$were("Weredeer (Stag)", 20, ST*3, 10, HT+4, 1, 2, 12, "format('antlers: cr %s, trample: cr 1d+1', thrust(`st`,0))", , 2)
			$$were("Weredeer (Doe)", 15, ST*2, 10, HT+2, 1, 2, 14, "'trample: cr 1d-1'", , 2)
			$$were("Were-eagle", 20, ST, 13, , , 3, 20, "format('talons: imp %s', thrust(`st`,0))", bodyweight/2, 1)
			$$were("Werehorse (Stallion)", 25, ST*3, 9, HT+4, , , 15, "format('kick: cr %s, bite cr 2', thrust(`st`,0))",  bodyweight*4, 3,
				, , , , Disadv:Bad Temper|Disadv:Berserk)
			$$were("Werehorse (Mare)", 25, ST*3, 9, HT+4, , , 15, "format('kick: cr %s, bite 2 cr', thrust(`st`,0))",  bodyweight*4, 3)
				original Werehorse
			$$were("Wereleopard", 30, ST*2, 14, HT+2, 1, 1, 9, "format('bite: cut %s', thrust(`st`,0))", , 2)
				opt text Note "Senses and Stealth at 18."
					end
			$$were("Werelion", 40, ST*3, 13, HT+3, 1, 1, 10, "format('bite: cut %s, claws: cut %s', thrust(`st`,0), thrust(`st`,0))", bodyweight*3, 2)
			$$were("Weresnake", 10, ST*2, 13, , , 3, 4, 'Constriction', , 4, , , , x_ht*2)
			$$were("Weretiger", 40, ST*3, 14, HT+2, 1, 3, 10, "format('bite: cut %s, claws: cut %s', thrust(`st`,0), thrust(`st`,0))", bodyweight*4, 2)
			$$were("Werewolf", 15, ST, 14, HT+2, 1, 3, 9, "format('bite: cut %s', thrust(`st`,0))", , 1)
			end
		$$cadv("Snatcher", 80, , Occult/Paranormal, , , , , "tcfunc(max(c+a,50),0,@mo@,@p@))")
			opt
				add "Weight" "?:1;5 lbs., -0;3 lbs., -5;2 lbs.,-10;1 lb.,-15;4 oz.,-20;1 oz.,-25"
				add "Extra Time" "?:1;10 sec.,-0;1 min.,-5;5 min.,-10;30 min.,-15"
				#add "Specialization" "?:1;Anything,-0;Only Weapons,-10;Only Information,-15;Only Money,-10;Only Metal,-5;No Metal,-15;Only Blue Things,-20"
				begin add "Specialization" "??0;0;x*-5;x>=0" 
					dispexp "format('l: o')"
					end
				add "Stunning" "?+0;-10"
				add "Uncontrollable" "?+0;-20"
				end
		$$cadv("Special Rapport", 10, , Occult/Paranormal)
		$$cadv("Spirit Empathy", 10, , Occult/Paranormal)
		$$cadv("Super Luck", 100, , Occult/Paranormal)
		$$cadv("Temporal Inertia", 15, , Occult/Paranormal)
		$$cadv("Time-Jumper", 100, , Occult/Paranormal, , , , , "tcfunc(max(c+a,60),0,@mo@,@p@))")
			opt
				add "Drift" "?+0;-15"
				add "Limited Range" "?+0;-10"
				add "Stunning" "?+0;-10"
				add "Uncontrollable" "?+0;-10"
				add "No Concentration Required" "?+0;+15"
				add "Teleport Jump" "?+0;+10"
				end
		$$cadv("True Faith", 15, , Occult/Paranormal)
		$$cadv("Visualization", 10, , Occult/Paranormal)
		$$cadv("World-Jumper", 100, , Occult/Paranormal, , , , , "tcfunc(max(c+a,60),0,@mo@,@p@))")
			opt
				add "Cannot Escort Another Jumper" "?+0;-10"
				add "Cannot Follow Another Jumper" "?+0;-20"
				add "Drift" "?+0;-15"
				add "Stunning" "?+0;-10"
				add "Uncontrollable" "?+0;-10"
				add "New Worlds" "?+0;+50"
				add "No Concentration Required" "?+0;+15"
				add "Reduced Fatigue" "?+0;+20"
				add "Teleport Jump" "?+0;+10"
				add "Tracking" "?+0;+20"
				end
		$$cadv("World Sight", 10, , Occult/Paranormal, , RitualAptitude+5)
		end
	sublist "Racial" memlist
		$$racialreq(Racial Prerequisites)
		$$racialreq(Taboo Trait, Taboo Trait)
		sublist "Attribute Limits" memlist
			$$item(Attribute Limits)
				textline sformat %0ln format %0ln cat "Attribute Limits"
				textline editdlg 5
				textline prereq "!#1,Advantages:Attribute Limit;!#1,Advantages:Attribute Limits"
				opt
					begin adj "Minimum ST" "MinST+x" "0" keepold end
					begin adj "Minimum DX" "MinDX+x" "0" keepold end
					begin adj "Minimum IQ" "MinIQ+x" "0" keepold end
					begin adj "Minimum HT" "MinHT+x" "0" keepold end
					begin adj "Maximum ST" "MaxST+x" "0" keepold end
					begin adj "Maximum DX" "MaxDX+x" "0" keepold end
					begin adj "Maximum IQ" "MaxIQ+x" "0" keepold end
					begin adj "Maximum HT" "MaxHT+x" "0" keepold end
					end
			$$MaxAtt(ST, 0)
			$$MaxAtt(DX, 0)
			$$MaxAtt(IQ, 0)
			$$MaxAtt(HT, 0)
			$$MinAtt(ST, 0)
			$$MinAtt(DX, 0)
			$$MinAtt(IQ, 0)
			$$MinAtt(HT, 0)
			end
		$$lsupadv("Early Maturation", 5, , , , , , , , , Racial Advantage)
		$$lsupadv("Enhanced Move", 5, , , , "half level", , "^n (^o|Multiplier|)", , enh_move, Racial Advantage)
			opt begin exp Multiplier "format('%d',1+x/2)" noprint end
				begin exp "Speed" "runningSpeed" qual "running" end
				end
		$$lsupadv("Enhanced Move (Swimming)", 5, , , , "half level", , "^n (^o|Multiplier|)", , enh_swim, Racial Advantage)
			opt begin exp Multiplier "format('%d',1+x/2)" noprint end
				begin exp "Speed" swimmingSpeed qual swimming end
				end
		$$lsupadv("Enhanced Move (Flying)", 5, , , , "half level", , "^n (^o|Multiplier|)", , enh_flight, Racial Advantage)
			opt begin exp Multiplier "format('%d',1+x/2)" noprint end
				begin exp "Speed" flyingSpeed qual flying end
				end
		$$lsupadv("Extended Lifespan", 5, , , !Disadv:Short Lifespan, , , , , extLifespan, Racial Advantage)
		$$flsupadv("Mindshare", 20, 60, "Type of Link", "Hive Mind,20;Racial Memory,40;Global Consciousness,60", , Racial Advantage, , ,
				"`No Cost`?0:tcfunc(c,a,@mo@,@p@)-@bonus@")
			opt
				add "Type of Drone" "?:1;Intelligent,25;Defense,15;Maintenance,5;Mindless,-10"
				add "Mindshare Distance" "?:2;Touch Only,-15;1 mile,+0;100 miles,+10;1000 miles,+20;Planet-wide,+30;System-wide,+40;Galaxy-wide,+50;Universal,+60;Multi-universal,+75"
				begin add "Number of Drones" "??2;0;(x-2)*10;x>0;Must be > 0"
					dispexp "format('l: %n-%n, o', t>1?10^(t-1):2, t>1?10^t-1:9)" end
				percent "Detectable Without Telepathy" "?+0;-20%"
				percent "Can be Blocked/Jammed" "?+0;-10%"
				percent "Limited to Speed of Light" "?+0;-10%"
				percent "Normal Telepathy" "?+0;-10%"
				end
		sublist "Racial Attributes" memlist
			$$rhw(Height, "max(round((min(64+max(st,5)+b_height-5,84))*(1+m_height)),min_height)-(sex=2?2:0)",
				b_height*m_height*min_height, "^x|dispInch(`Height`)|")
			$$rhw(Weight, "heightweight(height)+b_weight+incdensity-(sex=2?10:0)",
				height*exbodyweight*b_weight*incdensity, "^x|dw(`Weight`)|")
			$$item(Racial Height and Weight)
				textline cat "Racial Height and Weight"
				textline prereq "!Racial Height;!Racial Weight;!#1,Adv:Racial Height and Weight"
				textline editdlg 5 
				textline format "%0ln (^x|`Racial Height`>=0?'+':''|^x|dispInch(`Racial Height`)|, ^x|`Racial Weight`>=0?'+':''|^x|dw(`Racial Weight`)|)"
				textline sformat %0ln
				opt
					begin adj "Racial Height" b_height+x;max_height+x ??0 noprint dispexp "format('l: %s',dispInch(o))" keepold end
					begin adj "Racial Weight" b_weight+x ??0 noprint dispexp "format('l: %s', dw(o))" keepold end
					end

			$$lsupadv("Lower Body Strength", Variable,
				LBST+x;st_jump+x-10;st_encum+x,
				"x+~st-10>0", , , "enhStCost(x)", , %0ln%-10r!Variable, , Racial Advantage)
				opt percent "No Fine Manipulators" "?+1;-40%"
					exp "Lower Body Strength" x+(~st-10)
					end
			$$raceAttrBonus(Upper Body Strength, ST, "enhStCost(x+iteminfo('`Base`'))-enhStCost(iteminfo('`Base`'))",
				"st_jump+`Doesn't Affect Jumping`?0:x;STBonus+x;STSpellFatigue+x;st_skilldef+x")
				opt
					begin percent "Doesn't Affect Jumping" "?+1;-5%" noprint end
					end
			$$raceAttrBonus(Natural ST, ST, "enhStCost(x+iteminfo('`Base`'))-enhStCost(iteminfo('`Base`'))")
				opt begin percent Natural ??-40% noprint end end
			$$raceAttrBonus(Racial ST, ST, "enhStCost(x+optValue('Base'))-enhStCost(optValue('Base'))",
				"st_jump+`No Jumping Bonus`?0:x;STBonus+`No Fatigue Bonus`?0:x;STSpellFatigue+(`No Fatigue Bonus` or `No Spell-Casting Fatigue Bonus`)?0:x;st_skilldef+`Doesn't Affect Skills`?0:x")
				opt
					percent "No Jumping Bonus" "?+0;-5%"
					percent "No Fatigue Bonus" "?+0;-30%"
					percent "No Spell-Casting Fatigue Bonus" "?+0;-20%"
					percent "Doesn't Affect Skills" "?+0;-5%"
					end
			$$raceAttrBonus(Racial DX, DX)
			$$raceAttrBonus(Racial Fatigue, x_st, x*c_xst)
			$$raceAttrBonus(Racial HT, HT, , HTBonus+x)
			$$raceAttrBonus(Racial IQ, IQ)
			$$raceAttrBonus(Racial Hits, x_ht, x*c_xht)

			$$item("Split ST")
				textline dsid "$(PLUGIN)"
				textline cat "Racial Advantage"
				textline totalcostformula "ceil((ceil(enhStCost(`Upper`+10)*.95)+ceil(enhStCost(`Lower`)*.6))/2)"
				textline format "%0ln +^o'Upper'/^o'Lower'%-14rc%-7r!"
				textline sformat %0ln
				textline editdlg 2
				textline adj "st+`Upper`;STBonus+`Upper`;STSpellFatigue+`Upper`;st_skilldef+`Upper`;st_jump+`Lower`-10;LBST+`Lower`;st_encum+`Lower`"
				opt
					begin text Upper ??0 noprint dispexp "format('l: +o')" end
					begin text Lower ??10 noprint end
					end

			$$csupadv("Quadruped Encumbrance", 0, 
				"lightmult=6;lightred=2;lightmin=2;medmult=10;medred=4;medmin=2;hvymult=15;hvyred=6;hvymin=2;xhvymult=20;xhvyred=8;xhvymin=1", , , , Racial Advantage)
			$$csupadv("Winged Being Encumbrance", 0, "lightmult=6;lightred=4;medmult=10;medred=8;hvymult=15;hvyred=12;xhvymult=15;xhvyred=12", , , , Racial Advantage)
			end
		sublist "Racial Skill Bonuses" memlist
			$$ladv("Group Skill Bonus", 6, "\"Sk:`~Group`\"+x", , , , Racial Skill Bonus, , 
					"%0ln (^x|optPresent('Skill Name')?listOptions('optValue', 'Skill Name', ', '):optValue('Group')|)%-14rc%-7r!+^v")
				textline dupexpected
				opt	begin text Group "Name" keepold noprint end
					end
			$$ladv("Small Group Skill Bonus", 3, "\"Sk:`~Group`\"+x", , , , Racial Skill Bonus, ,
					"%0ln (^x|optPresent('Skill Name')?listOptions('optValue', 'Skill Name', ', '):optValue('Group')|)%-14rc%-7r!+^v")
				dupexpected
				opt	begin text Group "Name" keepold noprint end
					end
			$$ladv("Racial Skill Bonus (PE)", PE/2, "\"Sk:`~Skill`\"+x", "pe(x,1)/2", "x>0 and x<=3", , , , "%0ln: ^o'Skill'%-14rc%-7r!+^v")
				dupexpected
				opt	begin text Skill "Name" noprint keepold selitem *Skills end
					end
			$$ladv("Racial Skill Bonus (PA)", PA/2, "\"Sk:`~Skill`\"+x", "pa(x,1)/2", "x>0 and x<=3", , , , "%0ln: ^o'Skill'%-14rc%-7r!+^v")
				dupexpected
				opt	begin text Skill "Name" noprint keepold selitem *Skills end
					end
			$$ladv("Racial Skill Bonus (PH)", PH/2, "\"Sk:`~Skill`\"+x", "ph(x,1)/2", "x>0 and x<=3", , , , "%0ln: ^o'Skill'%-14rc%-7r!+^v")
				dupexpected
				opt	begin text Skill "Name" noprint keepold selitem *Skills end
					end
			$$ladv("Racial Skill Bonus (ME)", ME/2, "\"Sk:`~Skill`\"+x", "me(x,1)/2", "x>0 and x<=3", , , , "%0ln: ^o'Skill'%-14rc%-7r!+^v")
				dupexpected
				opt	begin text Skill "Name" noprint keepold selitem *Skills end
					end
			$$ladv("Racial Skill Bonus (MA)", MA/2, "\"Sk:`~Skill`\"+x", "MA(x,1)/2", "x>0 and x<=3", , , , "%0ln: ^o'Skill'%-14rc%-7r!+^v")
				dupexpected
				opt	begin text Skill "Name" noprint keepold selitem *Skills end
					end
			$$ladv("Racial Skill Bonus (MH)", MH/2, "\"Sk:`~Skill`\"+x", "MH(x,1)/2", "x>0 and x<=3", , , , "%0ln: ^o'Skill'%-14rc%-7r!+^v")
				dupexpected
				opt	begin text Skill "Name" noprint keepold selitem *Skills end
					end
			$$ladv("Racial Skill Bonus (MVH)", MVH/2, "\"Sk:`~Skill`\"+x", "MVH(x,1)/2", "x>0 and x<=3", , , , "%0ln: ^o'Skill'%-14rc%-7r!+^v")
				dupexpected
				opt	begin text Skill "Name" noprint keepold selitem *Skills end
					end
			end
		$$csupadv("Radio Speech", 25, , , , , Racial Advantage)
			deleteauto autoitems "Radio Hearing"
		$$zcadv("Secret Communication", 20, , "Racial Advantage")
			opt
				percent "Imperceptable" "?+0;+40%"
				percent "Only general concepts and emotions" "?+0;-50%"
				end
		
		$$csupadv("Subsonic Speech", 20, , , , , Racial Advantage)
			deleteauto autoitems "Subsonic Hearing"
		$$csupadv("Ultrasonic Speech", 25)
			deleteauto autoitems "Ultrahearing"
		end
	sublist "Super Advantages" memlist
		$$nadv("Extra Flexibility", , "$Single Limb;1;Whole Body;2", x*5, x=1 or x=2)
		end
	sublist "Super Advantages" memlist
		$$csupadv(360-Degree Vision, 25)
		$$lsupadv(Absorption, Variable, , x>0, , , "x*itemInfo('`Absorbs`')", "^n (^o'Absorbs')", "^n%-10r!Variable")
			opt	begin text Absorbs "?:1;Very Rare,2;Rare,4;Occasional,8;Common,10;Everything,12"  noprint end
				percent "Points Go Into One Attribute/Power" ?+0;-20%
				end
		$$lsupadv("Altered Time Rate", 100, , x>=-1)
		$$zcadv("Amphibious", 10, , "Super Advantage", , amphibious+1, , , , vAmphibious)
		$$csupadv("Bioelectric Shock", 10)
			opt text Damage 1d
				end
		$$csupadv("Bite", 30)
			opt
				begin add "Damage" "??0;0;x*5;x>=0;Must be >= 0" dispexp "format('l +t, +o')" end
				end
		sublist "Body Covering" memlist
			$$csupadv("Fur (Very Thin Fur)", 0)
			$$csupadv("Fur", 4, "idr+1;temperaturetolerance+1")
				deleteauto autochargecost dontmarkauto noautodup
				autoitems "Temperature Tolerance=1"
			$$zcadv("Fur (Thick Fur)", 29, , "Super Advantage", , "ipd+1;idr+1;temperaturetolerance+2")
				deleteauto autochargecost dontmarkauto noautodup
				autoitems "Temperature Tolerance=2"
			$$csupadv("Fur (Spiny Fur)", 33, "ipd+1;idr+1")
				notes "Imp 1d-2 in close combat."
			$$csupadv("Scales (Very Light Scales)", 0)
			$$csupadv("Scales", 3, "idr+1")
			$$csupadv("Scales (Heavy Scales)", 28, "ipd+1;idr+1")
			$$csupadv("Hide (Thick Hide)", 28, "ipd+1;idr+1")
			$$csupadv("Scales (Carapace)", 56, "ipd+2;idr+2")
			$$csupadv("Scales (Armor Plates)", 59, "ipd+2;idr+3")
			end
		$$csupadv("Body of Air", 50)
			$$enhlim(Carry Objects, "No,+0%;No Encumbrance, +10%;Light Encumbrance,+20%;Medium Encumbrance,+50%;Heavy Encumbrance,+100%")
		$$csupadv("Body of Air (Permanent)", -30)
			$$enhlim(Carry Objects, "No,+0%;No Encumbrance, -10%;Light Encumbrance,-20%;Medium Encumbrance,-50%;Heavy Encumbrance,-100%")
		$$csupadv("Body of Earth", 40)
			opt
				percent Unswitchable ?+0;-10%
				end
		$$lsupadv("Body of Fire", 5)
			notes "Cold and water attacks do +50% damage after DR subtracted"
			opt 	exp "Temperature of Flames" 500+25*x
				exp "DR vs. Heat/Fire" integer(x/2)
				exp "Extra DR vs. Bullets" integer(x/5)
				exp "Striking Damage" thr(integer(x/3))
				exp "Burn damage in hex" "max(1, integer(x/10))"
				percent "Unswitchable" ?+0;-40%
				end
		$$csupadv("Body of Ice", 25, "idr+5")
			opt
				percent "Unswitchable" ?+0;-60%
				end
		$$lsupadv("Body of Metal", 9, "ipd+min(6,integer(x/3));idr+x;a_move*0.8;dmgbonus+2")
			opt	percent "Non-Ferrous" "?+0;+10%"
				percent "Amorphous" "?+0;+30%"
				percent "Unswitchable" "?+0;-20%"
				end
		$$lsupadv("Body of Stone", 8,
			"ipd+min(6,integer(x/4));idr+integer(x*2/3);a_move*0.8;dmgbonus+2")
			opt	percent "Structure" "?:1;Crystalline,+0%;Amorphous,+30%"
				percent "Unswitchable" "?+0;-25%"
				end
			notes "Sonic and vibratory attacks considered armor piercing"
		$$cadv("Body of Water", 40)
			$$enhlim(Carry Objects, "No,+0%;No Encumbrance, +10%;Light Encumbrance,+20%;Medium Encumbrance,+50%;Heavy Encumbrance,+100%")
		$$cadv("Body of Water (Permanent)", -20)
			$$enhlim(Carry Objects, "No,+0%;No Encumbrance, -10%;Light Encumbrance,-20%;Medium Encumbrance,-50%;Heavy Encumbrance,-100%")
		$$lsupadv("Bouncing", 12, "idr_crush+x;\"Adv:Super Jump\"+integer(x/3)*not `No Super Jump abilities`")
			script "if (!$+inList(Advantages, Super Jump) and x>2 and not `No Super Jump abilities`)\
				addAutoItems \"Super Jump\", rv, deleteauto, noautodup, dontmarkauto, autochargecost; endif"
			opt
				percent "No Super Jump abilities" ?+0;-25%
				exp "Extra DR vs. Crushing Damage" x
				exp "Extra PD vs. Physical Attacks" "min(integer(x/5), 6)"
				end
		$$csupadv("Brachiator", 5)
			deleteauto dontmarkauto noautodup autochargecost
			autoitems "?List:Skills;?opt:Base Level='dx-2';Skills:Acrobatics;?zopt;?opt:Base Level='DX';Skills:Climbing"
			opt
				exp "Brachiating Move" round(move/2)
				end
		##lsupadv("Breath Holding", 2)
		$$lsupadv("Broadcast", 3, , , "Advantages:Radio Hearing")
			opt
				percent "Video broadcast" ?+0;+40%
				end
		$$csupadv("Cast Iron Stomach", 15)
		$$csupadv("Catfall", 10)
		$$lsupadv(Chameleon, 7)
			opt
				add "Unswitchable" ?+0;-5
				exp "Stealth skill (moving)" "max(stealth,iq-5,dx-5)+x"
				exp "Stealth skill (still)" "max(stealth,iq-5,dx-5)+x*2"
				end

		$$csupadv(Clinging, 25)
			opt
				percent "Cling To" "?:1;Anything,-0%;One Common substance,-30%;One Rare substance,-50%"
				end
		$$lsupadv("Compartmentalized Mind", 50)
		$$csupadv("Constriction Attack", 15, , "Extra Flexibility")
		$$csupadv(Costume, 15)
		$$see(Damage Resistance, , , DR)
		$$lsupadv(DR, , "idr+x", , , ,
				"~x*itemInfo('`Versus`')", "^n (^o'Versus')", "^n%-10r!Variable")
			opt	begin text Versus "?:1;Everything,3;Common,2;Occasional,1;Rare,1/2;Very Rare,1/4" noprint end
				begin percent "Hardened" "??0;0;x*30;x>=0 and x<=2"
					dispexp "'l: t, +o%'"
					end
				end
		$$lsupadv(Skull DR, 1.5, "b_HeadDR+x", , , , "round(x*1.5)")

		$$lsupadv(Ablative DR, , "idr+x", x>0, , ,
				"x*itemInfo('`Regenerates`')", "^n (^o'Regenerates')", "^n%-10r!Variable")
			opt	begin text Regenerates "?:1;1/day,1;1/hour,1.5;1/min,2" noprint end
				begin percent "Hardened" "??0;0;x*30;x>=0 and x<=2"
					dispexp "'l: t, +o%'"
					end
				end
		$$csupadv("Dark Vision", 25)
			opt percent "See Colors" "?+0;+20%"
				end
		$$zcadv("Decreased Life Support", 10, , "Super Advantage")
		$$csupadv("Discriminatory Smell", 15, tasteorsmell+4;tracking+4)
			$$enhlim	Sensitivity to Odor	No,-0%;Common,-50%;Occasional,-20%;Rare,-10%
			opt
				percent "Sense Emotional State" ?+0;+50%
				end
		$$csupadv("Discriminatory Taste", 10, tasteorsmell+4)
		$$csupadv("Doesn't Breathe", 20)
		$$zcadv("Doesn't Eat or Drink", 10, , "Super Advantage")
		$$csupadv("Doesn't Sleep", 20)
		$$csupadv("Dominance", 5)
			opt
				begin add "Controlled" "??0;0;x*15;x>=0" dispexp "format('l: %n points, +o', t*100)" end
				end
		$$lsupadv("Drug Factory", Variable, , "x>0", , drug, "10+x*10")
		$$lsupadv(Duplication, 75, , , , copy, "x*(75+optValue('Constant Telepathic Contact')*25)")
			opt
				begin text "Constant Telepathic Contact" ?+0; dispexp "'l: +25'" end
				percent "Death of Dupe Doesn't Stun Others" ?+0;+20%
				percent "Dupes Do Not Share Full HT" ?+0;-40%
				end
		$$csupadv("Elastic Skin", 20)
		$$lsupadv(Enhanced Strength, Variable, "p_st+`Override ST`?x:0", "x>=ST", , , "max(0,enhStCost(x)-enhStCost(st))",
			, "%0ln%-10r!Variable", enhancedST)
			opt
				begin text "Override ST" "?+0;" noprint dispexp 'l' end
				begin percent "Activates at Growth Level" "??0;0;x<6?-x*10:-60;x<=growth;Must be <= Growth Level"
					dispexp "'l: t, o%'"
					end
				exp Thrust thrust(x,0)
				exp Swing swing(x,0)
				end
		$$zcadv("Enhanced Time Sense", 45, , "Super Advantage", , "\"Advantages:Combat Reflexes\"+1")
			textline deleteauto noautodup autochargecost dontmarkauto
			textline autoitems "Combat Reflexes"
			opt add "All Psionics are Instantaneous" "?+0;+15" end
		$$lsupadv("Extra Arms", Variable, , "x>0", , , "x*optvalue('Cost per Arm')", , %0ln%-10r!Variable)
			opt
				exp "Cost per Arm" "`Physical Attack`=1?`Reach`:dround(min(`Reach`,10)/2)+10*max(`Reach`/10-1, 0)"
				begin text "Reach" "??0;5;x<1?5:x*10;x>=0;Must be >= 0" dispexp "t>0?format('l: t, %+d', o):format('l: Close, %+d', o)" end
				begin text "Physical Attack" "?+1;" dispexp 'l' end
				percent "Legless while using Extra Arms" "?+0;-35%"
				end
		$$lsupadv("Extra Arm Length", 10, , , , hex/arm, x*10)
			opt
				mult "Number of Arms" "??1"
				end
		$$zcadv("Extra Encumbrance", 5, , "Super Advantage", , "lightmult=5;medmult=10;hvymult=20;xhvymult=30")
		$$flsupadv("Extra Legs", 5, 10, "Legs", "3-4 Legs,5;5-6 Legs,10;7+ Legs,15", , , , , "`No Cost`?0:tcfunc(c,a,@mo@,@p@)-@bonus@")
			opt
				begin add "Reach" "??1;0;10*(x-1);x>=1;Must be >= 1" dispexp "t>0?format('l: t, %+d', o):format('l: Close, %+d', o)" end
				add "Kick" "?:2;No,-5;Yes,+0"
				end
		$$csupadv("Faz Sense", 10)
		$$csupadv("Field Sense", 10)
		$$zcadv("Filter Lungs", 5, , "Super Advantage")
		$$csupadv(Flexibility, 15, Sk:climbing+5;Sk:escape+5;Sk:mechanic+5,
			!Advantages:Double-Jointed)
		$$csupadv(Flight, 40, flightCapable+1, , x+0*flyingSpeed, , , "`No Cost`?0:tcfunc(c,a,@mo@,@p@)-@bonus@")
			opt	begin exp Speed "flyingSpeed" qual flying end
				percent "Winged Flight" "?:1;No Wings,-0%;Large Wings,-25%;Small Wings,-10%"
				percent "Motion Limitation" "?:1;None,-0%;Cannot Hover,-15%;Controlled Gliding,-45%;Gliding,-50%"
				percent "Flight ceiling" "?:1;None,-0%;30 feet,-10%;10 feet,-20%;5 feet,-25%"
				exp MPH "format('%n',round(`Speed`*2.0455))"
				end
		$$lsupadv("Full Coordination", 50, , , , attack)
		$$zcadv("Gills", 10, , "Super Advantage")

		$$item(Growth)
			textline varname growth
			textline formula 10*x+height*0
			textline level 1
			textline checkexp x>0
			textline format "%0ln (Max. Size: ^o'Maximum Size')%-14rc%-7rv"
			textline sformat "%0ln%-17r!10/level"
			textline totalcostformula "ceil((c+a)*max((100+@p@+growthcostred)/100,0.25)))"
			textline adj "growthcostred+`Maximum Size Only`?-min(x*10,60):0;minGrowthST=qindex(x,20,36,56,90,150,240,350,500+(x-8)*150)"
			textline prereq "Enhanced Strength>=max(20,minGrowthST)|Main:ST>=max(20,minGrowthST)"

			opt
				begin exp "Maximum Size" "x<0?'--':format(\"%d'%d''\", integer(height*(x+1)/12), (height * (x+1)) mod 12)" noprint end
				begin text "Maximum Size Only" "?+0;" dispexp "'l'" end
				exp "Cost Reduction" "format('%d%%',growthcostred)"
				exp "Minimum ST" minGrowthST
				end

		$$csupadv(Healing, 25)
			opt
				percent "Works On" "?:1;Similar Races,+0%;All Mammals,+20%;All Earthly Life,+40%;All Carbon-Based Life,+60%;Anything Alive,+80%;Anything Animate,+100%"
				percent "Single Race" "?+0;-20%"
				end
		$$zcadv("Hermaphromorph", 2, , "Super Advantage")
		$$csupadv("Hyperactive", 30, b_speed+2)
		$$csupadv("Hyperflight (c)", 50, , "Advantages:Super Flight")
			opt exp "Speed (c)" superflight
				percent "Can Maneuver While Hyperflying" ?+0;+10%
				percent "Cannot Clearly Navigate" ?+0;-30%
				end
		$$csupadv("Hyperflight (ly/day)", 75, , "Advantages:Super Flight")
			opt exp "Speed (ly/day)" superflight
				percent "Can Maneuver While Hyperflying" ?+0;+10%
				percent "Cannot Clearly Navigate" ?+0;-30%
				end
		$$zcadv("Hyper-Reflexes", 15, , "Super Advantage")
		$$zcadv("Hyper-Strength", 30, , "Super Advantage")
		$$csupadv("Ice Skates", 5)
		$$csupadv(Immortality, 140, NoAging+1, "!#1,Advantages:Unaging;!Disadv:Age", , , Unaging)
			notes "Includes Instant Regeneration, Immunity to Disease, Immunity to Poison and Unaging"
		$$zcadv("Immunity to Poison", 15, , "Super Advantage")
		$$lsupadv("Increased Density", 5, incdensity+x*100;idr_crush+x;Skills:Swimming-5*x)
			opt exp "Extra DR against Crushing Damage" x end
		$$lsupadv("Independently Focusable Eyes", 15, , "x>=1", , "eye")
			opt exp "Eyes" "x+1" end
		$$csupadv(Infravision, 15)
		sublist "Injury Tolerance" memlist
			$$csupadv("Injury Tolerance (No Blood)", 5)
			$$csupadv("Injury Tolerance (No Brain)", 5)
			$$csupadv("Injury Tolerance (No Cutting Bonus)", 20)
			$$csupadv("Injury Tolerance (No Impaling Bonus)", 20)
			$$csupadv("Injury Tolerance (No Cutting or Impaling Bonus)", 30)
			$$csupadv("Injury Tolerance (No Neck)", 5)
			$$zcadv("Injury Tolerance (No Vitals)", 5, , "Super Advantage")
			end
		$$csupadv(Insubstantiality, 80)
			$$enhlim(Carry Objects, "No,+0%;No Encumbrance, +10%;Light Encumbrance,+20%;Medium Encumbrance,+50%;Heavy Encumbrance,+100%")
			opt
				percent "Unswitchable" ?+0;-50%
				end
 		$$csupadv(Invisibility, 40)
			$$enhlim(Carry Objects, "No,+0%;No Encumbrance, +10%;Light Encumbrance,+20%;Medium Encumbrance,+50%;Heavy Encumbrance,+100%")
			opt
				percent "Become Visible at Will" ?+0;+10%
				percent "Can Be Seen in Mirrors" ?+0;-10%
				begin percent "Invisible to Other Types of Vision" "??0;0;x*20;x>=0;Must be >= 0" dispexp "'l: +t, +o%'" end
				end
 		$$csupadv("Invisibility to Machines", 20)
			$$enhlim(Carry Objects, "No,+0%;No Encumbrance, +10%;Light Encumbrance,+20%;Medium Encumbrance,+50%;Heavy Encumbrance,+100%")
			opt
				percent "Become Visible at Will" ?+0;+10%
				percent "Does not Appear in Mirrors" ?+0;+10%
				end
		$$nadv(Invulnerability, , "$Very Rare;1;Rare;2;Occasional;3;Common;4;Any Kinetic Damage;5",
				"qindex(x,50,75,100,150,300)", x>0 and x<=5, , Super Advantage)
			opt
				percent "Attacks don't cause knockback" ?+0;+20%
				end
		$$lsupadv("Magnetic Sense", 5)
		$$csupadv("Matter Surfing", 30)
			opt
				percent "Track doesn't vanish immediately" "?+0;-10%"
				percent "Fly at any height" ?+0;+33%
				percent "Land automatically if unconscious" ?+0;+50%
				percent "Track left does 1 die damage/2 turns" ?+0;+40%
				end
		$$lsupadv("Metabolism Control", 5)
			opt
				percent "Hibernation" "?+0;-50%"
				end
		$$lsupadv("Microscopic Vision", 4, , , , , , "^n (^o'Magnification')")
			opt
				begin exp "Magnification" "format('%d',2^x)" noprint end
				end
		$$csupadv("Mimicry", 15)
		$$lsupadv("Modified Arm DX", Variable, , "(dx+x)>0", , , "attCost(x+10)", , %0ln%-10r!Variable)
			opt
				percent "Arms" "?:1;One Arm,-40%;Two Arms,-20%"
				exp "Arm DX" "dx+x"
				end
		$$lsupadv("Modified Arm ST", Variable, , "(st+x)>0", , , "stCost(x+10)", , %0ln%-10r!Variable)
			opt
				percent "Arms" "?:1;One Arm,-70%;Two Arms,-50%;Three Arms,-20%"
				exp "Arm ST" "st+x"
				end
		$$csupadv("Morph", 40)
		$$csupadv("Move Through Ice", 10)
			opt
				percent "Optionally Leave Tunnel Behind" ?+0;+40%
				end
 		$$lsupadv("Multiple Forms", 5, , , , form)
			opt
				percent "Takes" "?:1;Less than 1 min.,-0%;1d min. to switch,-20%;1d hours to switch,-40%"
				percent "Absorptive Change" "?:1;No,+0%;No Encumbrance,+10%;Light Encumbrance,+20%;Medium Encumbrance,+50%;Heavy Encumbrance,+100%"
				mult "Absorptive Change Both Ways" "?+0;2"
				begin exp "Average Total" multformavg(0) noprint end
				begin text "File Name" "" editdlg 1 end
				end
		$$lsupadv("Nictating Membrane", 10)
			opt
				exp "Eye PD" "min(x*2,6)"
				exp "Eye DR" x
				end
		$$csupadv("Oxygen Storage", 14)
		$$lsupadv("Parabolic Hearing", 4)
		$$see(PD, , , Passive Defense)
		$$lsupadv("Passive Defense", 25, ipd+x, "x>0 and x<7")
		$$csupadv("Penetrating Call", 5)
		$$lsupadv("Penetrating Vision", 10)
			opt
				exp "Vision Depth" "format('%d in.',x*6)"
				percent "Vision Blocked by" "?:1;Nothing,-0%;Specific substance,-10%;Less common substance,-20%;Common substance,-30%"
				percent "See Through" "?:1;Anything,-0%;Common Substance,-40%;Uncommon Substance,-60%;Absurd Substance,-80%"
				end
		$$csupadv("Perfect Balance", 15, "Skills:piloting+1;Skills:Acrobatics+1;Skills:climbing+1;Skills:flight+1)")
			notes "DX+6 on slippery surfaces. DX+4 to keep on feet in combat"
		$$zcadv("Pheromone Control", 25, , "Super Advantage")
 		$$csupadv("Polarized Eyes", 5)
		$$flsupadv("Pressure Support", 5, 15, "Up To", "Any Amount,15;100normal,10;10normal,5")
 		$$item("Radar Sense") formula 50+x*1 level 1
			textline checkexp x>0
			textline totalcostformula $(supcostform)
			textline format "%0ln (^o'Range' ^o'Range In')%-14rc%-7rv"
			textline sformat "%0ln%-17r!50+1/hex radius"
			opt exp "Range" x
				begin exp "Range In" "optTextValue('Type')='Low-Res'?'miles':(optTextValue('Type')='Imaging'?'hexes':'hexes or miles')" noprint end
				percent "See colors" ?+0;+20%
				percent "See inside any object" ?+0;+40%
				percent "Type" "?:1;Imaging,+0%;Low-Res,+0%;Imaging and Low-Res,+50%"
				end
		$$csupadv("Radio Hearing",10)
		$$zcadv("Recovery", 10, , "Super Advantage")
		$$csupadv("Reduced Sleep", 10)
		$$lsupadv(Reflection, , , x>0, , ,
				"x*itemInfo('`Versus`')", "^n (^o'Versus')", "^n%-10r!Variable")
			opt	begin text Versus "?:1;Everything,8;Common,6;Occasional,4;Rare,2;Very Rare,1" noprint end
				end
		$$nadv(Regeneration, , "$1 HT/12 hrs.;1;1 HT/hour;2;1 HT/min;3;1 HT/turn;4",
			"max(0,qindex(x,10,25,50,100)-qindex(&x+1,0,10,25,50,100))", x>=&x and x>0 and x<=4, , Super Advantage, ,
			"%0ln (^v)%-14rx'displev(@c@)'%-7r!")
		$$zcadv("Regrowth", 40, , "Super Advantage")
			opt percent "Only Small Extremities" "?+0;-50%" end
		$$csupadv(Resurrection, 150)
			opt
				percent "Resurrection Prevented by" "?:1;Nothing,-0%;Rare Materials,-10%;Common Material,-30%"
				percent "Unhealable Damage" "?:1;None,-0%;Very Rare,-10%;Occasional,-20%;Common,-30%"
				percent "Killed Permanently by" "?:1;Nothing,-0%;Rare Vulnerability,-5%;Occasional Vulnerability,-15%;Common Vulnerability,-25%"
				percent "Reincarnation" ?+0;-20%
				end
		$$csupadv("Sanitized Metabolism", 5, "Skills:sexappeal+1")
		$$csupadv("See Invisible",15)
		$$csupadv("Sense of Perception", 100)
		$$csupadv("Sensitive Touch", 10)
		$$csupadv("Shadow Form", 50)
			$$enhlim(Carry Objects, "No,+0%;No Encumbrance, +10%;Light Encumbrance,+20%;Medium Encumbrance,+50%;Heavy Encumbrance,+100%")
		$$csupadv("Shadow Form (Permanent)", -20)
			$$enhlim(Carry Objects, "No,+0%;No Encumbrance, -10%;Light Encumbrance,-20%;Medium Encumbrance,-50%;Heavy Encumbrance,-100%")
		$$lsupadv(Shrinking, , , x>0, , , "(x<6)*(x*20)+(x>5)*((x-4)*100)", , "^n%-10r!Variable")
			$$enhlim(Carry Objects, "No,+0%;No Encumbrance, +10%;Light Encumbrance,+20%;Medium Encumbrance,+50%;Heavy Encumbrance,+100%")
			opt
				percent "Affects Others" "??0;0;x*50;x>=0;Must be >= 0"
				exp "Minimum Size" "format('%2n in.', height/2^x)"
				percent "Damage remains normal" ?+0;+100%
				percent "Retain normal hit points" ?+0;+30%
				end
		$$lsupadv("Shrinking (Permanent)", , , x>0, , , "max((-15-(x>1)*5-(x>2)*10*(x-2)-(x>4)*10*(x-4)),-100)", , "^n%-10r!Variable")
			$$enhlim(Carry Objects, "No,+0%;No Encumbrance, -10%;Light Encumbrance,-20%;Medium Encumbrance,-50%;Heavy Encumbrance,-100%")
			opt
				exp "Size" "format('%2n in.', height/2^x)"
				percent "Damage remains normal" ?+0;-100%
				percent "Retain normal hit points" ?+0;-30%
				end

		$$lsupadv(Silence, 5)
			opt exp "Stealth Bonus (Moving)" x
				exp "Stealth Bonus (Motionless)" x*2
				end
		$$csupadv("Sonar Vision", 25)
		$$csupadv("Speak Underwater", 8)
			opt
				percent "Talk With Those out of Water" ?+0;+50%
				end
		$$csupadv("Speak with Animals", 15)
			$$enhlim	Speak with	Any Animal,-0%;One Phylum,-20%;One Family,-30%;One Species,-50%
		$$csupadv("Speak with Fish", 10)
		$$csupadv("Speak with Plants", 15)
		$$csupadv("Spectrum Vision", 40)
		$$lsupadv(Stretching, , "Sk:climbing+5*not `SWoF`;Sk:escape+5*not `SWoF`;Sk:mechanic+5*not `SWoF`", 
			x>0, !Flexibility;!Double-Jointed, ,
			"30+x*15", , "^n%-15r!30+15/level")
			opt
				begin percent "Stretch Without Flexibility" ?+0;-50% alias SWoF end
				end
		sublist "Strikers" memlist
			sublist "Claws" memlist
				$$zcadv(Claws, 15, , "Super Advantage", , , , "`No Cost`?0:tcfunc(c,@bonus@+a,@mo@,@p@)")
					opt exp "Damage" "format('cr %s',thr(2+dmgbonus))" 
						add "Reduced Skill" "??0;0;x;x<=0;Must be <= 0"
						begin add "Reach" "??0;0;x*5;x>=0;Must be >= 0" dispexp "t>0?format('l: t, %+d', 0):format('l: Close, %+d', o)" end
						end
				$$zcadv("Claws (Sharp Claws)", 25, , "Super Advantage", , , , "`No Cost`?0:tcfunc(c,@bonus@+a,@mo@,@p@)")
					opt exp Damage "format('cut %s',thr(dmgbonus))"
						add "Reduced Skill" "??0;0;x;x<=0;Must be <= 0"
						begin add "Reach" "??0;0;x*5;x>=0;Must be >= 0" dispexp "t>0?format('l: t, %+d', 0):format('l: Close, %+d', o)" end
						end
				$$zcadv("Claws (Long Talons)", 55, , "Super Advantage", , , , , "`No Cost`?0:tcfunc(c,@bonus@+a,@mo@,@p@)")
					opt exp "Damage" "format('imp %s, cut %s', thr(2+dmgbonus), sw(dmgbonus+2))"
						add "Reduced Skill" "??0;0;x;x<=0;Must be <= 0"
						begin add "Reach" "??0;0;x*5;x>=0;Must be >= 0" dispexp "t>0?format('l: t, %+d', 0):format('l: Close, %+d', o)" end
						end
				$$zcadv("Claws (Talons)", 40, , "Super Advantage", , , , , "`No Cost`?0:tcfunc(c,@bonus@+a,@mo@,@p@)")
					opt exp "Damage" "format('imp %s, cut %s', thr(dmgbonus), sw(dmgbonus))"
						add "Reduced Skill" "??0;0;x;x<=0;Must be <= 0"
						begin add "Reach" "??0;0;x*5;x>=0;Must be >= 0" dispexp "t>0?format('l: t, %+d', 0):format('l: Close, %+d', o)" end
						end
				end
			$$zcadv("Generic Striker", 5, , "Super Advantage", , , , , "`No Cost`?0:tcfunc(c,@bonus@+a,@mo@,@p@)")
				opt
					exp "Damage" "format('cr %s',thr(dmgbonus))"
					begin add "Reach" "??0;0;x*5;x>=0;Must be >= 0" dispexp "t>0?format('l: t, %+d', o):format('l: Close, %+d', o)" end
					add "Reduced Skill" "??0;0;x;x<=0;Must be <= 0"
					end
			sublist "Horns" memlist
				$$zcadv("Butting Horns", 5, , "Super Advantage", , , , , "`No Cost`?0:tcfunc(c,@bonus@+a,@mo@,@p@)")
					opt exp "Damage" "format('cr %s',thr(dmgbonus))"
					begin add "Reach" "??0;0;x*5;x>=0;Must be >= 0" dispexp "t>0?format('l: t, %+d', 0):format('l: Close, %+d', o)" end
					add "Reduced Skill" "??0;0;x;x<=0;Must be <= 0"
					end
				$$zcadv("Long Tusks", 50, , "Super Advantage", , , , , "`No Cost`?0:tcfunc(c,@bonus@+a,@mo@,@p@)")
					opt
						exp "Damage" "format('imp %s, cut %s', thr(dmgbonus), sw(dmgbonus))"
						begin add "Reach" "??1;0;(x-1)*5;x>=0;Must be >= 0" dispexp "t>0?format('l: t, %+d', o):format('l: Close, %+d', o)" end
						add "Reduced Skill" "??0;0;x;x<=0;Must be <= 0"
						end
				end
			$$zcadv("Spear", 30, , "Super Advantage", , , , , "`No Cost`?0:tcfunc(c,@bonus@+a,@mo@,@p@)")
				opt
					exp "Damage" "format('imp %s', thr(1+dmgbonus))"
					begin add "Reach" "??1;0;(x-1)*5;x>0;Must be > 0" dispexp "format('l: t, %+d', o)" end
					add "Reduced Skill" "??0;0;x;x<=0;Must be <= 0"
					end
			sublist "Spines" memlist
				$$zcadv("Short Spines", 5)
					opt
						text "Damage" "imp 1d-2"
						begin add "Reach" "??0;0;x*5;x>=0;Must be >= 0" dispexp "t>0?format('l: t, %+d', 0):format('l: Close, %+d', o)" end
						end
				$$zcadv("Long Spines", 15)
					opt
						text "Damage" "imp 1d"
						begin add "Reach" "??0;0;x*5;x>=0;Must be >= 0" dispexp "t>0?format('l: t, %+d', 0):format('l: Close, %+d', o)" end
						end
				end
			sublist "Teeth" memlist
				$$zcadv("Blunt Teeth", 0, , "Super Advantage", , , , , "`No Cost`?0:tcfunc(c,@bonus@+a,@mo@,@p@)")
					opt exp Damage "format('cr %s', t_thrdmg)"
						add "Reduced Skill" "??0;0;x;x<=0;Must be <= 0"
						begin add "Reach" "??0;0;x*5;x>=0;Must be >= 0" dispexp "t>0?format('l: t, %+d', 0):format('l: Close, %+d', o)" end
						end
				$$zcadv("Sharp Teeth", 5, , "Super Advantage", , , , , "`No Cost`?0:tcfunc(c,@bonus@+a,@mo@,@p@)")
					opt exp Damage "format('cut %s', t_thrdmg)"
						add "Reduced Skill" "??0;0;x;x<=0;Must be <= 0"
						begin add "Reach" "??0;0;x*5;x>=0;Must be >= 0" dispexp "t>0?format('l: t, %+d', 0):format('l: Close, %+d', o)" end
						end
				$$zcadv("Fangs", 10, , "Super Advantage", , , , , "`No Cost`?0:tcfunc(c,@bonus@+a,@mo@,@p@)")
					opt exp Damage "format('imp %s', t_thrdmg)"
						add "Reduced Skill" "??0;0;x;x<=0;Must be <= 0"
						begin add "Reach" "??0;0;x*5;x>=0;Must be >= 0" dispexp "t>0?format('l: t, %+d', 0):format('l: Close, %+d', o)" end
						end
				end
			end
		$$csupadv("Subsonic Hearing", 5, "Skills:tracking+1")
		$$lsupadv("Super Climbing", 3, , , , , x*3+0*speed)
			opt
				begin exp Speed "(speed*(1+enh_move/2)-red_move)+x" qual climbing end
				end
		$$lsupadv("Super Flight", 20, , , Flight, , , "^n (^o'Multiplier')")
			opt
				begin exp Multiplier "format('%d',2^x)" noprint end
				end
		$$lsupadv("Super Jump", 10)
			opt exp "High Jump (feet)" round((max(jumping,jumpST)*3.0-10)*2.0^x/12)
				begin exp "Broad Jump (yards)" round((max(jumping,jumpST)-3.0)*2.0^x/3) end
				begin exp Speed "max(base_move, round((max(jumping,jumpST)-3.0)*2.0^x/15)))" qual jumping end
				exp MPH "format('%n',round(`Speed`*2.0455))"
			end
		$$lsupadv("Super Running", 20, superRunning+x, , , , x*20+0*runningSpeed, , , sup_run)
			opt begin exp "Speed" "runningSpeed" qual running end
				exp MPH "format('%n',round(`Speed`*2.0455))"
				end
		$$lsupadv("Super Swimming", 10, superSwimming+x, , Amphibious, , x*10+0*swimmingSpeed)
			opt begin exp "Speed" "swimmingSpeed" qual swimming end
				exp MPH "format('%n',round(`Speed`*2.0455))"
				end
		$$lsupadv("Telescopic Vision", 6)
		$$csupadv("Transference", 40)
		$$csupadv(Transformation,15)
		$$lsupadv(Tunnel, , , x>0, , , "40+x*10", , "^n%-15r!40+10/level")
			opt begin exp "Speed" x qual tunneling end
				exp "Speed (rock)" x/2
				end
		$$csupadv("Ultrahearing", 5)
		$$csupadv("Undying", 175, NoAging+1, "!#1,Advantages:Unaging;!Disadv:Age", , , Unaging)
		$$csupadv("Universal Digestion", 15)
		$$csupadv("Vacuum Adaptation", 27, "idr+1;temperaturetolerance+10")
			deleteauto autochargecost dontmarkauto noautodup
			autoitems "Temperature Tolerance=10"
		$$zcadv("Vacuum Support", 40, , "Super Advantage")
		$$csupadv("Vampiric Immortality", 60, NoAging+1, "!#1,Advantages:Unaging;!Disadv:Age", , , Unaging)
		$$csupadv("Vampiric Invulnerability", 150)
		$$csupadv("Vampiric Resurrection", 150)
		$$lsupadv("Venom", 15)
			opt
				text "Type" "?:1;Corrosive;Poisonous;Irritant"
				percent "Contact Agent" "?+0;+70%"
				percent "Ranged" "?+0;+35%"
				percent "Cloud of Mist" "?+0;+100%"
				percent "Sweat (Passive Delivery)" "?+0;-70%"
				end
		$$csupadv("Walk on Air", 20)
		$$csupadv("Walk on Liquid", 15)
		$$lsupadv("Webbing", , , x>=0, , , "20+x*2", , "^n%-15r!20+2/ST point")
			opt
				exp "Web ST" "st+x"
				end
		end
	end

cat "Disadvantages"
	sublist "Silly Disadvantages" memlist
		$$nadv("Evil Twin", , "$Identical;1;Higher Skills;2;Better Abilities;3;Better Skills and Abilities;4",
				"qindex(x,-10,-15,-15,-20)", x>0 and x<=4, , Silly)
			opt
				mult "Roll" "?:2;6 or less,1/2;9 or less,1;12 or less,2;15 or less,3"
				end
		$$nadv("Klutz", , "$Standard;1;Total;2", "min(0,(x=1?-5:-15)-qindex(&x+1,0,-5,-15))", "x>=&x and (x=1 or x=2)", "Main:DX<=13", Silly, ,
			"%0ln^x|@v@>1?format(' (%s)', itemInfo('@level@')):''|%-14rx'displev(@c@)'%-7r!")
		end
	sublist "Social Disadvantages" memlist
		$$nadv("Disowned", , "$Another Heir Named;1;Wholly and Publicly;2", x=1?-5:-15, x=1 or x=2, , Social)
			opt exp Reaction "-x"
				end
		$$nadv("Excommunicated", , "$Social/Political;1;Supernatural;2", x*-5, x=1 or x=2, , Social)
		$$cadv(Extremely Hazardous Duty, -20, , Social)
		$$ladv("Ignorance", -5, , , "x>0", , Social)
		$$cadv("Mistaken Identity", -5, , Social)
		$$nadv("Secret Identity", , 
				"$Serious Embarassment;1;Utter Rejection;2;Imprisonment or Exile;3;Possible Death;4",
				"qindex(x,-5,-10,-20,-30)-(status>2?10:0)", x>0 and x<=4, , Social, secretIdentity)
			opt
				begin exp "Status" status noprint end
				end
		$$cadv("Uneducated", -5, "!#1,Spells", Social)
		end
	sublist "Physical Disadvantages" memlist
		$$cadv("Acceleration Weakness", -5, , Physical)
		$$nadv("Bad Back", ,"$Mild;1;Severe;2", x=1?-15:-25, x=1 or x=2, , Physical)
		$$cadv("Bad Smell", -10, , Physical)
			opt text "Reaction" ??-2
				end
		$$cadv("Bowlegged", -1, , Physical, , "Skills:jumping-1")
		$$nadv("Cyber-Rejection", , "$Uncommon;1;Common;2", x=1?-10:-25, x=1 or x=2, , Physical)
		$$nadv("Delicate Metabolism", , "$Severe Disorder;1;Special Nutrients;2", x*-20, x=1 or x=2, , Physical)
		$$flsupadv(Dependency, -5, -30, Substance, "Common,-5;Occasional,-10;Infrequent,-20;Rare,-30", , Super Disadvantage, , ,
			"tcfunc(c,a-`Causes Aging`,@mo@,@p@)+`Causes Aging`-@bonus@")
			opt
				add "Illegal Substance" "?+0;-5"
				mult "Frequency" "?:1;Monthly,1;Weekly,2;Daily,3;Hourly,4;Constantly,5"
				mult "Missed Dose Causes" "?:1;HT Loss,1;Loss of Powers Only,1/2"
				add "Causes Aging" "?+0;-10"
				end
		$$cadv("Disturbing Voice", -10, "!Advantages:Voice", Physical)
			opt exp "Reaction" -2 end
		$$ladv("Extra Sleep", -3, , , "x<=4 and x>0", , Physical)
		$$cadv("Free Sick", -10, , Physical)
		$$nadv("G-Intolerance", , "$0.1 G Increment;1;0.05 G Increment;2", x*-10, x=1 or x=2,
			!Adv:Improved G-Tolerance, Physical)
		$$cadv("Hunchback", -10, "Main:ST<=15;Main:dx<=14;Main:ht<=16", Physical, , b_height-6;hunchback+1)
		$$nadv("Insomniac", , "$3d Days Between Episodes;1;2d-1 Days Between Episodes;2", x=1?-10:-15, x=1 or x=2, , Physical)
		$$cadv("Light Sleeper", -5, , Physical)
		$$nadv("Migraine", , "$6 or less;1;8 or less;2;11 or less;3;13 or less;4", x*-5, x>0 and x<=4, , Physical, , "%0ln (^v)%-14rc%-7r!")
		$$cadv("Missing Digit", 0, , Physical, , , , "%0ln%-10r!Variable")
				editdlg 2
			opt
				exp "Left Hand DX" "`Left Fingers Missing`/2+`Left Thumb Missing`+dx"
				exp "Right Hand DX" "`Right Fingers Missing`/2+`Right Thumb Missing`+dx"
				add "Left Fingers Missing" "??0;0;x*-2;x>=0 and x<5;Must be 0-4"
				add "Left Thumb Missing" "?+0;-5"
				add "Right Fingers Missing" "??0;0;x*-2;x>=0 and x<5;Must be 0-4"
				add "Right Thumb Missing" "?+0;-5"
				end
		$$cadv("Motion Sickness", -10, "!#1,Skills:Vehicle", Physical)
		$$cadv("Night Blindness", -10, "!Advantages:Night Vision;!Advantages:Dark Vision", Physical)
		$$cadv("No Depth Perception", -10, !One Eye, Physical, , "Sk:Melee-1;Sk:Ranged-3;Sk:Driving-3;Sk:Piloting-3;Sk:Powerboat-3;Sk:Motorcycle-3;Sk:ForwardObserver-1")
		$$cadv("No Physical Body", -100, , Physical, , "FatigueBOIQ+1;ST0Required+1;Hits1Required+1;fright+5")
			script "if ($*st <> 0) Main.ST=0; endif if ($*x_ht <> 1) Main.x_ht=1; endif"
			opt exp "Fright Check" willpower+fright end
		$$cadv("Quadriplegic", -50, , Physical, , "st-4;dx-4")
		$$ladv("Reduced Manual Dexterity", -3, Sk:Manual-x, , , , Physical)
		$$cadv("Scalped", -5, , Physical)
		$$cadv("Sleepwalker", -5, , Physical)
		$$cadv("Social Disease", -5, , Physical)
		$$cadv("Space Sickness", -10, "!Skills:freefall", Physical)
		$$zcadv("Sterile", -3, , Physical)
		$$cadv("Susceptibility to Poison", -5, , Physical)
		$$nadv("Timesickness", , "$Nuisance;1;Mild;2;Severe;3;Very Severe;4;Nightmare;5;Critical;6",
			"qindex(x,-2,-5,-10,-15,-15,-20)", x>0 and x<=6, , Physical, , , "round((c+a)*m)-`Campaign Default`")
			opt
				begin mult "Frequency" "?:2;Rare,1/2;Frequent,1;Very Frequent,1.5;Acute,2" end
				begin text "Campaign Default" ??0 noprint keepold end
				end
		$$nadv("Tourette's Syndrome", , "$Obvious;1;Difficult to Function;2", x*-15, x=1 or x=2, , Physical)
			opt
				add "Embarrassing Symptoms" "?+0;-5"
				end
		$$cadv("Unfit", -5, , Physical)
		$$zcadv("Unnatural Feature", -5, , Physical)
		$$cadv("Very Unfit", -15, "!Advantages:Immunity to Disease", Physical)
		$$cadv("Weak Immune System", -30, , Physical)
		end
	sublist "Mental Disadvantages" memlist
		# All social skills are affected by callous, except those listed, which are unaffected.
		$$cadv("Callous", -6, , Mental, , "Skills:Social-2;Skills:Intimidation+2;Skills:AreaKnowledge+2;Skills:TeaCeremony+2")
		sublist "Pacifism" memlist
			$$cadv("Pacifism (Cannot Harm Innocents)", -10, "!#1,Disadv:Pacifism", Mental;*Pacifism)
			end
		$$cadv("Cannot Learn", -30, , Mental)
		$$cadv("Charitable", -15, , Mental)
		$$cadv("Chronic Depression", -15, , Mental)
			opt
				begin add "Will Roll" "??0;0;x*-2;x>=0 and x<=5" dispexp "format('l: -t, o')" end
				end
		$$cadv("Chummy", -5, , Mental)
		$$cadv("Clueless", -10, , Mental, , "Skills:savoirfaire-4")
			opt exp "Reaction" -2 end
		sublist "Compulsive Behaviors" memlist
			$$nadv("Compulsive Gambling", , "$Less than 1 hr./day;1;1-6 hrs./day;2;More than 6 hrs./day;3",
				x*-5, x>0 and x<=3, , Mental)
			$$cadv("Compulsive Vowing", -5, , Mental)
			end
		$$cadv("Confused", -10, , Mental)
		sublist "Disciplines of Faith" memlist
			$$nadv("Disciplines of Faith", , "$Ritualism;1;Mysticism;2;Monasticism;3;Iconism;4;Asceticism;5",
				"qindex(x,-5,-10,-10,-10,-15)", x>0 and x<=5, , Mental)
			$$cadv("Devout Buddhist", -5, , Mental)
				opt text Reaction +1 end
			$$cadv("Shinto Priest", -5, , Mental)
				opt text Reaction +1 end
			end
		$$cadv("Easy to Read", -10, , Mental)
		$$cadv("Edgy", -5, , Mental, , fright-1)
			opt exp "Fright Check" willpower+fright end
		$$cadv("Extravagance", -10, , Mental)
		$$cadv("Extreme Fanaticism", -15, , Mental)
		$$cadv("Gregarious", -10, , Mental)
		$$cadv("Guilt Complex", -5, , Mental)
		$$cadv("Hidebound", -5, , Mental)
		$$cadv("Incurious", -5, , Mental)
		$$cadv("Indecisive", -10, , Mental)
		$$nadv("Innumerate", , "$Non-technological Society;1;Technological Society;2;Society Values Engineering Highly;3", 
			"qindex(x,-1,-5,-10)", x>0 and x<=3, , Mental)
		
		$$cadv("Loner", -5, , Mental)
		$$cadv("Lover's Distraction", -15, , Mental)
		$$cadv("Low Empathy", -15, "!Advantages:Empathy", Mental, , "Skills:Empathic-3")
		$$cadv("Low Self-Image", -10, , Mental)
		$$cadv("Lunacy", -10, , Mental)
		$$cadv("Nightmares", -5, , Mental)
		$$cadv("Non-Iconographic", -10, , Mental)
		$$cadv("Obdurate", -10, , Mental)
		$$cadv("Oblivious", -3, , Mental, , "Sk:Social-1")
		sublist "Phobias" memlist
			$$phobia("Parthenomania", -10)
			$$phobia("Fear of Being Alone", -15)
			$$phobia("Fear of Blood", -10)
			$$phobia("Fear of Cats", -5)
			$$phobia("Fear of Dogs", -5)
			$$phobia("Fear of Fire", -5)
			$$phobia("Fear of Psionic powers", -10)
			$$phobia("Fear of Spiders", -5)
			end
		$$cadv("Post-Combat Shakes", -5, , Mental)
		$$cadv("Prefrontal Lobotomy", -15, "!#1,Adv:Aggressive;!#1,Disadv:Aggressive", Physical)
		$$cadv("Reclusive", -10, , Mental)
		$$cadv("Self-Centered", -10, , Mental)
		$$cadv("Selfish", -5, , Mental)
		$$cadv("Selfless", -10, , Mental, , "will-1")
		$$cadv("Short Attention Span", -10, , Mental)
		$$cadv("Slave Mentality", -40, , Mental, , "will-6")
		$$cadv("Solipsist", -10, , Mental, , "Sk:Social-3")
		$$cadv("Trickster", -15, , Mental)
		sublist "Ultra-Tech" memlist
			$$cadv("Killjoy", -15, , Mental)
			$$cadv("VR Addiction", -25, , Mental)
			end
		$$nadv("Voices", , "$Annoying;1;Disturbing;2;Diabolical;3", x*-5, x>0 and x<=3, , Mental)
		
		$$cadv("Workaholic", -5, , Mental)
		$$nadv("Xenophilia", , "$Normal;1;Strong;2", x=1?-5:-15, x=1 or x=2, , Mental, , "%0ln^x|@v@>1?format(' (%s)', itemInfo('@level@')):''|%-14rc%-7r!")
		sublist "Quirks" memlist
			$$cadv	Attentive	-1		Mental
			$$cadv	Broad-Minded	-1		Mental
			$$cadv	Careful	-1		Mental
			$$cadv	Distractible	-1		Mental
			$$cadv	Dreamer	-1		Mental
			$$cadv	Dull	-1		Mental
			$$cadv	Humble	-1		Mental
			$$cadv	Imaginative	-1		Mental
			$$cadv	Proud	-1		Mental
			$$cadv	Responsive	-1		Mental
			$$cadv	Staid	-1		Mental
			$$cadv	Undiscriminating	-1		Mental
			end
		end
	sublist "Occult and Paranormal Disadvantages" memlist
		$$nadv("Allergic Susceptibility", , "$Occasional;1;Common;2;Very Common;3", x*-5, x>0 and x<=3)
			textline dupexpected
		$$cadv("Astral Entity", -25, , Occult/Paranormal)
		$$cadv("Bloodthirst", -15, , Occult/Paranormal)
		$$cadv("Cursed (Divine Curse)", -5, , Occult/Paranormal)
			textline keepcost
		$$cadv("The Draining", -10, , Occult/Paranormal)
		$$cadv("Dread", -10, , Occult/Paranormal)
			opt
				add "Radius (hexes)" "??1;0;-(x-1);x>=1"
				mult "Substance" "?:2;Rare,1/2;Occasional,1;Common,2;Very Common,3"
				mult "Spell broken by being carried in" "?+0;1/2"
				end
		$$nadv("Frightens Animals", , "$TL 5+;1;TL 4-;2", x*-5, x=1 or x=2)
			opt exp "Reaction" "format('+%d',x)" 
				end
		$$cadv("Infectious Attack", -5, , Occult/Paranormal)
		$$cadv("Lifebane", -10, , Occult/Paranormal)
			opt exp "Reaction" -2 end
		
		$$cadv("Mundane Background", -10, , Occult/Paranormal)
			keepcost
		$$cadv("Murder Addiction", -60, , Occult/Paranormal, , "Disadv:Sadism-5;Disadv:Bloodlust-5")
		$$cadv("No Body Heat", -5, , Occult/Paranormal, , , , , "`Gains Warmth After Feeding`?-1:c")
			opt	begin add "Gains Warmth After Feeding" ?+0; dispexp 'l' noprint end
				end
		$$ladv("Supersensitive", -2/level, , "~x*-2", "x>0", "Powers:Telepathy", Occult/Paranormal)
		$$fladv(Telepathic Addiction, -10, -20, Level,
			"Anyone,-10;Specific Individual,-20",
			"Skills:Telereceive>=10;Skills:Telesend>=10")
		$$cadv("Unique", -5, , Occult/Paranormal)
		$$cadv("Unliving", -50, , Occult/Paranormal)
		$$cadv("Untrained Shape-Changing", -15, , Occult/Paranormal)
		$$fladv("Yin-Yang Imbalance", -5, -10, "Type", "Overbearing Yin (Male),-10;Overbearing Yang (Male),-5;Overbearing Yin (Female),-5;Overbearing Yang (Female),-10", "Lecherousness")
		end
	sublist "Racial" memlist
		$$racialreq(Taboo Trait, Taboo Trait)
		$$csupadv("Dying Race", -10, , , , , Racial Disadvantage)
		$$csupadv("Hive Mentality", -20, will-2, , , , Racial Disadvantage)
		$$flsupadv("Inconvenient Size", -10, -15, "Size", "Over 8 feet tall,-10;Under 2 feet tall,-15;Over 1000 lbs.,-10", , Racial Disadvantage)
		$$csupadv("Planetbound", "Variable", , , , , Racial Disadvantage)
				textline editdlg 2
			opt
				add "Time Limit" "?:1;Two Years,-10;One Year,-20;Three Months,-30;One Month,-40"
				mult "Loses" "?:2;1 HT/2 weeks,׽;1 HT/week,1;1 HT/day,2"
				end
		$$nadv("Odious Racial Habit", , "$Bad;1;Very Bad;2;Disgusting;3", x*-5, x>0 and x<=3, , Social;Racial Disadvantage)
			dupexpected
			opt	exp Reaction -x
				end
		$$csupadv("Presentient", -20, , "Disadvantages:Illiteracy", , , Racial Disadvantage)
		$$flsupadv("Sleepy", -10, -35, "Sleeps", "50% of the time,-10;66% of the time,-20;75% of the time,-25;90% of the time,-35", , Racial Disadvantage)
		$$csupadv("Subjugation", -20, , , , , Racial Disadvantage)
		end
	sublist "Super Disadvantages" memlist
		$$csupadv("Anaerobic", -30, , , , , Super Disadvantage)
		$$csupadv("Aquatic", -40, , , , , Super Disadvantage)
		$$flsupadv("Bad/Poor Grip", -5, -10, "Level", "Poor Grip,-5;Bad Grip,-10", , Super Disadvantage)
		$$flsupadv("Bestial", -10, -15, "Level", "Normal,-10;Extremely Repugnant,-15", "!#1,Sk:Social;!#1,Sk:Artistic", Super Disadvantage)
		$$csupadv("Cannot Climb", -1, , , , , Super Disadvantage)
		$$csupadv("Cannot Swim", -1, , , , , Super Disadvantage)
		$$csupadv("Centauroid", 0, , , , , Super Disadvantage)
		$$flsupadv("Cold-Blooded", -5, -10, "Stiffen Up", "Below 50,-5;Below 65,-10", , Super Disadvantage)
		$$csupadv("Fragile", -20, , , , , Super Disadvantage)
		$$csupadv("Horizontal", -10, , , , , Super Disadvantage)
		$$csupadv("No Fine Manipulators", -30, "nofinemanip+1", , , , Super Disadvantage)
		$$csupadv("No Manipulators", -50, "nofinemanip+1", , , , Super Disadvantage)
		$$csupadv("No Reflection", -10, , , , , Super Disadvantage)
		$$csupadv("No Shadow", -10, , , , , Super Disadvantage)
		$$csupadv("Nocturnal", -10, , , , , Super Disadvantage)
		$$csupadv("One Fine Manipulator", -15, , , , , Super Disadvantage)
		$$csupadv("Pallor", -10, , , , , Super Disadvantage)
			opt add "Take on semblance of life after feeding" "?+0;+5" end
		$$flsupadv("Parasite", -15, -30, "Host", "Broad Category,-15;Specific Race,-30", , Super Disadvantage)
		$$lsupadv("Increased Life Support", -10, , , , , , , , , Super Disadvantage)
		$$csupadv("Invertebrate", -20, , , , , Super Disadvantage)
		$$lsupadv("Reduced Move", -5, , "integer(speed)-x>0 and x>=0", , Move, x*-5+0*runningSpeed, , , red_move, Super Disadvantage)
			opt begin exp "Speed" "runningSpeed" qual running end
				end
		$$lsupadv("Reduced Move (Swimming)", -5, , "`Speed`>0", , "Move", , , , red_swim, Super Disadvantage)
			opt begin exp "Speed" swimmingSpeed qual swimming end
				end
		$$lsupadv("Reduced Move (Flying)", -5, , , , "Move", , , , red_flight, Super Disadvantage)
			opt begin exp "Speed" flyingSpeed qual flying end
				end
		$$csupadv("Reprogrammable Duty", -25, , , , , Super Disadvantage)
		$$csupadv("Self-Destruct", -20, , , , , Super Disadvantage)
		$$csupadv("Semi-Upright", -5, , , , , Super Disadvantage)
		$$csupadv("Sessile", -50, , , , , Super Disadvantage)
		$$csupadv("Short Arms", -10, , , , , Super Disadvantage)
		$$lsupadv("Short Lifespan", -10, , , "!Adv:Extended Lifespan;!Adv:Longevity;!#1,Adv:Unaging", , , , , , Super Disadvantage)
		$$csupadv("Slow Eater", -10, , , , , Super Disadvantage)
		$$lsupadv("Slow Healing", -5, , , , , , , , , Super Disadvantage)
		$$lsupadv("Slow Metabolism", -60, , , , , , , , , Super Disadvantage)
		$$flsupadv("Stress Atavism", -12, -20, "Severity", "Mild,-12;Moderate,-16;Severe,-20", , Super Disadvantage)
			opt
				mult "Frequency" "?:1;Common (Will),*1;Uncommon (Will+3),*1/2;Rare (Will+5),*1/4"
				end
		$$lsupadv(Uncontrolled Change, -10, , x>=0, , , "optValue('Powers Lost')?-50:-10-x*10", , , , Super Disadvantage)
			opt
				exp "Reaction" -x
				begin text "Powers Lost" "?+0;" dispexp 'l' end
				end
		$$flsupadv("Unhealing", -20, -30, "Heal", "Under certain conditions,-20;Never,-30", , Super Disadvantage)
		$$csupadv("Unusual Biochemistry", -5, , , , , Super Disadvantage)
		$$csupadv("Vampiric Dependency", -50, , , , , Super Disadvantage)
		$$lsupadv(Vulnerability, 1, , , , , "x*itemInfo('`Frequency`')", "^n (^o'Frequency')", "^n%-12r!Variable", , Super Disadvantage)
			opt	begin text Frequency "?:1;Very Rare,-3;Rare,-5;Occasional,-10;Common,-15" noprint end
				percent "Range" "??0;0;x*10;x>=0;Must be >= 0"
				mult "Damage to" "?:1;Hit Points,*1;Fatigue,*1/2;Stun,*1/2"
				end
		$$lsupadv(Weakness, 1, , , , , "~x*itemInfo('`Frequency`')", "^n (^vd/^o'Frequency', ^o'Rarity')", "^n%-12r!Variable", , Super Disadvantage)
			opt	begin text Frequency "?:1;30 Min.,-5;5 Min.,-10;Minute,-20" noprint end
				begin mult Rarity "?:2;Rare,׽;Occasional,1;Common,2;Very Common,3" noprint end
				mult "Damage to" "?:1;Hit Points,*1;Fatigue,*1/2;Stun,*1/2"
				end
		end
	end

cat "Skills"
	sublist "Animal" memlist
		$$skill("Bulldancing", PH, "Animal;Artistic;Athletic", "acrobatics-5")
		$$skill("Bullfighting", PA, "Animal;Combat/Weapon;Athletic", "dx-5")
		$$skill("Equestrian Acrobatics", PH, "Animal;Athletic", "acrobatics-3;cat:'Riding'-3", "#1,Sk:Riding>=slc(12)")
		$$skill("Riding (Being Ridden)", PA, "Animal;Athletic", "dx-5")
		$$skill("Snake Charming", MA, "Animal", "animalhandling-4;hypnotism-2")
		end
	sublist "Artistic" memlist
		$$skill("Appreciate Beauty", MVH, "Artistic;Craft;Social", "iq-5;savoirfaire-5;cat:'Artistic'-5;cat:'Craft'-5")
		$$see("Bulldancing", %-5l!PH)
		$$skill("Choreography", MA, "Artistic", "dancing-2", "Sk:Leadership>=slc(12);Sk:Dancing>=slc(12)")
		$$see("Combat/Weapon Art", , Combat/Weapon Art or Sport)
		$$skill("Conducting", MA, "Artistic", "iq-5;cat:'Musical Instrument'-2", "Sk:Leadership;#2,Sk:Musical Instrument")
		$$skill("Cyberaxe", MH, "Artistic;Musical Instrument", "cat:'Musical Instrument'-4", , tl/8+)
		$$skill("Directing", MH, "Artistic", "PerformanceSkill-5", "Sk:Leadership>=slc(12);Sk:Performance>=slc(12)")
		$$skill("Featherworking", MA, "Artistic", "iq-5")
		$$skill("Fight Choreography", MA, "Artistic", "stagecombat-2", "Sk:Leadership>=slc(12);Sk:Stage Combat>=slc(12)")
		$$skill("Fire Eating", PA, "Artistic")
		$$skill("Flower Arranging", ME, "Artistic", "iq-4")
		$$skill("Gardening", ME, "Artistic", "iq-4")
		$$skill("Illumination", PA, "Artistic;*Manual", "artist-2;dx-5")
		$$see("Juggling", %-5l!PE)
		$$see("Lucid Dreaming", %-5l!ME)
		$$skill("Make-Up", ME, "Artistic", "iq-4;disguise", , tl)
		$$skill("Musical Composition", MH, "Artistic;*Musical", "musicalinstrument-2", "#1,Sk:Musical Instrument>=iq|Sk:Conducting>=iq")
		$$skill("Neurophon", MVH, "Artistic;Musical Instrument", , "Sk:Physiology>=10")
		$$skill("Origami", ME, "Artistic", "iq-4")
		$$skill("Picture-Writing", MH, "Artistic", "picturewriting-3", "Adv:Literacy")
		$$skill("Punning", MA, "Artistic", "bard-3", "#1,Skills:Language>=13")
		$$skill("Scene Design", MA, "Artistic", "iq-5;architecture-3")
		$$skill("Sensie Interface", MH, "Artistic", "cyberdeckoperation-3")
		$$skill("Stage Combat", PA, "Artistic;Athletic;Combat/Weapon;*Melee", "PerformanceSkill-3")
		$$see("Symbol Drawing", %-5l!MH)
		$$see("Weaving", %-5l!PE)
		end
	sublist "Athletic" memlist
		sublist "Acrobatics Maneuvers" memlist
			$$martman	Tumbling	Spec	Acrobatics	Acrobatics>=12	Acrobatics
			$$martman	Team Acrobatics	Hard	Acrobatics	Acrobatics>=12	Acrobatics+4
			$$martman	Stilt Walking	Avg	Acrobatics	Acrobatics>=12	Acrobatics+4
			$$martman	Aerial Acrobatics	Hard	Acrobatics-2	Acrobatics>=12	Acrobatics+4
			$$martman	Tightrope Walking	Hard	Acrobatics-2	Acrobatics>=12	Acrobatics+4
			$$martman	Gymnastics	Hard	Acrobatics	Acrobatics>=12	Acrobatics+4
			end
		$$see("Bulldancing", %-5l!PH)
		$$see("Combat/Weapon Sport", , Combat/Weapon Art or Sport)
		$$see("Darts", %-5l!PE)
		$$see("Equestrian Acrobatics", %-5l!PH)
		$$skill("Flight (Gliding)", PA, Athletic;*Flight, "dx-4;cat:'Flight'-2")
		$$skill("Flight (Unwinged)", PA, Athletic;*Flight, "dx-4;cat:'Flight'-2")
		$$skill("Flight (Winged)", PA, Athletic;*Flight, "dx-4;cat:'Flight'-2")
		$$skill("Inertialess Agility", PH, Athletic)
		$$skill("Juggling", PE, "Athletic;Artistic;*Manual", "sleightofhand-3;teamjuggling-2")
		$$skill("Team Juggling", PE, Athletic, "juggling-2")
		$$skill("Lifting", PH/ST, Athletic;Sport)
		$$skill("Low-G Flight", PA, Athletic, "st-6;pilotingultralight-4;pilotingglider-4", , tl)
		$$skill("Riding (Flying Person)", PA, Athletic;*Riding, "dx-5;cat:'Riding'-4;surfboard-4;skateboard-4")
		$$skill("Skating", PH, "Athletic;Sport;Outdoor", "dx-6")
		$$see("Stage Combat", %-5l!PA)
		end
	sublist "Combat/Weapon" memlist
		$$skill("Blowpipe (Fukiya)", PE, "Combat/Weapon;Athletic;Ranged", "dx-4")
		$$skill("Fanning", PE, "Combat/Weapon;Athletic", "GunsPtl-4;dx-6", , tl/6+)
		$$skill("Fast-Draw (Knife from Teeth)", PE, "Combat/Weapon;Athletic", , , , , , , fastdraw)

		$$mcskill("Fencing (Rapier)", PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon;*Fencing;*Sword",
			"dx-5;cat:'Fencing'-3", , , , , , , , "(c?2/3:.5)+wpbonus(0)")
		$$mcskill("Fencing (Saber)", PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon;*Fencing;*Sword",
			"dx-5;cat:'Fencing'-3", , , , , , , , "(c?2/3:.5)+wpbonus(0)")
		$$mcskill("Fencing (Smallsword)", PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon;*Fencing;*Sword",
			"dx-5;cat:'Fencing'-3", , , , , , , , "(c?2/3:.5)+wpbonus(0)")

		$$skill("Fire-Siphon", PA, "Combat/Weapon;Athletic;Ranged", "dx-5")
		$$mcskill("Force Whip", PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed", "whip-3", , tl/8+)
		$$skill("Garrote", PE, "Combat/Weapon;Athletic;*Melee;*Close;*Weapon", "dx-5")
		$$skill("Harpoon", PH, "Combat/Weapon;Athletic;Ranged;*Weapon;*Long Weapon", "spearthrowing-2")
		$$mcskill("Main-Gauche", PA, "Combat/Weapon;Athletic;*Melee;*Close;*Weapon;*One-Handed", "dx-5", , , , , , , , "(c?2/3:.5)+wpbonus(0)")
		$$skill("Monowire Whip", PH, "Combat/Weapon;Athletic;*Melee;*Weapon;*Long Weapon", "whip-2", , tl/8+)
		$$skill("Slipping the Hammer", PE, "Combat/Weapon;Athletic", "GunsPtl-2;dx-5", , tl/6+)
		$$see("Stage Combat", %-5l!PA)
		$$skill("Throwing (Rock-Dropping)", PH, "Combat/Weapon;Athletic;Ranged", "throwing-4")

		sublist "Combat/Weapon Art or Sport" memlist
			$$mcskill("Broadsword Art", PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon;*Combat Sport;*Sword Sport", "broadsword-3;BroadswordSport-3:KatanaArt-2")
			$$mcskill("Fencing Art", PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon;*Fencing Sport;*Combat Sport;*Sword Sport", "dx-5;cat:'Fencing'-3", , , , , , , , "(c?2/3:.5)+wpbonus(0)")
			$$mcskill("Fencing Sport", PA, "Combat/Weapon;Athletic;Sport;*Melee;*Weapon;*One-Handed;*Long Weapon;*Fencing Sport;*Combat Sport;*Sword Sport", "dx-5;cat:'Fencing'-3", , , , , , , , "(c?2/3:.5)+wpbonus(0)")
			$$mcskill("Karate Art", PH, "Combat/Weapon;Athletic;*Melee;*Combat Sport", karate-3;karatesport-3, , , , , , , , "(c?2/3:.5)+b_bhparry+combatreflexes")
			$$mcskill("Karate Sport", PH, "Combat/Weapon;Athletic;Sport;*Melee;*Combat Sport", karate-3;karateart-3, , , , , , , , "(c?2/3:.5)+b_bhparry+combatreflexes")
			$$mcskill("Judo Art", PH, "Combat/Weapon;Athletic;*Melee;*Combat Sport", Judo-3;Judosport-3, , , , , , , , "(c?2/3:.5)+b_bhparry+combatreflexes")
			$$mcskill("Judo Sport", PH, "Combat/Weapon;Athletic;Sport;*Melee;*Combat Sport", Judo-3;Judoart-3, , , , , , , , "(c?2/3:.5)+b_bhparry+combatreflexes")
			$$mcskill	Katana Art	PA	Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon;*Combat Sport;*Sword Sport	dx-5;BroadswordArt-2;Katana-3;KatanaSport-3								(c?2/3:.5)+wpbonus(0)
			$$mcskill	Katana Sport	PA	Combat/Weapon;Athletic;Sport;*Melee;*Weapon;*One-Handed;*Long Weapon;*Combat Sport;*Sword Sport	dx-5;BroadswordArt-2;KatanaArt-3;Katana-3								(c?2/3:.5)+wpbonus(0)
			$$skill(Wrestling Sport, PA, "Combat/Weapon;Athletic;Sport;*Melee;*Combat Sport", "dx-5;Wrestling-3")
			$$mcskill("Shortsword Art", PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon;*Combat Sport;*Sword Sport", "dx-5;broadswordArt-2;shortsword-3")
			$$mcskill(Generic PA Combat/Weapon Art, PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Combat Sport", "`Default`")
				uniquevar rand -1
				opt begin text Default "Skill-3" noprint keepold end end
			$$mcskill(Generic PE Combat/Weapon Art, PE, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Combat Sport", "`Default`")
				uniquevar rand -1
				opt begin text Default "Skill-3" noprint keepold end end
			$$mcskill(Generic PH Combat/Weapon Art, PH, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Combat Sport", "`Default`")
				uniquevar rand -1
				opt begin text Default "Skill-3" noprint keepold end end
			$$mcskill(Generic PA Combat/Weapon Sport, PA, "Combat/Weapon;Athletic;Sport;*Melee;*Weapon;*One-Handed;*Combat Sport", "`Default`")
				uniquevar rand -1
				opt begin text Default "Skill-3" noprint keepold end end
			$$mcskill(Generic PE Combat/Weapon Sport, PE, "Combat/Weapon;Athletic;Sport;*Melee;*Weapon;*One-Handed;*Combat Sport", "`Default`")
				uniquevar rand -1
				opt begin text Default "Skill-3" noprint keepold end end
			$$mcskill(Generic PH Combat/Weapon Sport, PH, "Combat/Weapon;Athletic;Sport;*Melee;*Weapon;*One-Handed;*Combat Sport", "`Default`")
				uniquevar rand -1
				opt begin text Default "Skill-3" noprint keepold end end
			end

		# GURPS Martial Arts skills.

		$$skill("Body Language", MH, "Combat/Weapon;Athletic", "psychology-3;DetectLies-3", , , "MMH(~x-vision,iq)")
		$$mcskill	Jitte/Sai	PA	Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon;*Close	dx-5;Shortsword-3
		$$mcskill	Katana	PA	Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon;*Sword	dx-5;Broadsword-2;TwoHandedSword-2;KatanaArt-3;KatanaSport-3								(c?2/3:.5)+wpbonus(0)
		$$mcskill	Kusari	PH	Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon	dx-5;Flail-2
		$$skill	Parry Missile Weapons	PH	Combat/Weapon;Athletic
		$$skill("Sensitivity", MVH,"Combat/Weapon;Athletic", , , , "mvh(~x,iq+(dx>11)+(dx>13))")
		$$mcskill	Short Staff	PH	Combat/Weapon;Athletic;*Melee;*Weapon;*Long Weapon;*One-Handed	dx-5;Staff-2
		$$skill	Shuriken	PH	Combat/Weapon;Athletic;Ranged;*Weapon	dx-6;Throwing-2
		$$skill	Style Analysis	MH	Martial Arts	BodyLanguage-6;Tactics-6
		$$skill	Sumo Wrestling	PA	Combat/Weapon;Athletic;*Melee;*Hand-to-Hand;Sport
		$$mcskill	Tonfa	PH	Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon	dx-6;Shortsword-3
		end
	sublist "Craft" memlist
		$$see("Appreciate Beauty", %-5l!MVH)
		$$skill("Beverage-Making", ME, "Craft", "iq-4")
		$$skill("Cooperage", ME, "Craft", "iq-4;dx-4#dx")
		$$skill("Distilling", MA, "Craft", "iq-4")
		$$skill("Dyeing", MA, "Craft", "iq-4")
		$$skill("Fireworks", MH, "Craft", "iq-6;chemistry-3", , tl)
		$$skill("Glassblowing", PH, "Craft", "dx-6")
		$$skill("Masonry", PE, "Craft", "iq-3")
		$$skill("Needlecraft", PA, "Craft;*Manual", "dx-4")
		$$skill("Netmaking", PE, "Craft;*Manual", "dx-6")
		$$skill("Shipbuilding (Starship)", MA, "Craft", "iq-5;shipbuilding-5", "Configuration:TL>=8-&tl", tl/8+)
		$$skill("Stone Knapping", MA, "Craft", "iq-5", , 0)
		$$skill("Tanning", PA, "Craft", "iq-4")
		$$skill("Tattooing", MA, "Craft", "iq-5")
		$$skill("Weaving", PE, "Artistic;Craft", "dx-2;iq-4#iq")
		end
	sublist "Esoteric" memlist
		$$skill("Augury", MVH, "Esoteric", "theology-4;occultism-3")
		$$skill("Autohypnosis", MH, "Esoteric")
		$$skill("Change Control", MH, "Esoteric", , "Adv:Multiple Forms")
		$$skill("Chi Treatment", MH, "Esoteric;Medical", "iq-6")
		$$skill("Dreaming", MVH, "Esoteric", "iq-10")
		$$skill("Enthrallment (Persuade)", MA, "Esoteric", , "Sk:Bard>=slc(12);Adv:Charisma>=1")
		$$skill("Enthrallment (Sway Emotions)", MA, "Esoteric", , "Sk:Enthrallment (Persuade)>=slc(12);Adv:Charisma>=1")
		$$skill("Enthrallment (Suggest)", MH, "Esoteric", , "Sk:Enthrallment (Persuade)>=slc(12);Adv:Charisma>=1")
		$$skill("Enthrallment (Captivate)", MH, "Esoteric", , "Sk:Enthrallment (Suggest)>=slc(12);Adv:Charisma>=1")
		$$skill("Fire Walking", ME, "Esoteric", "iq+will-5")
		$$skill("Lucid Dreaming", ME, "Artistic;Esoteric", "iq+will-4")
		$$skill("Meditation", MVH, "Esoteric")
		$$skill("Meditation (Realistic)", MH, "Esoteric", "iq-5")
		$$skill("Nei Tan", MVH, "Esoteric")
		$$skill("Ritual Magic", MVH, "Esoteric;Knowledge")
		$$skill("Shapeshifting", MH, "Esoteric", , "Adv:Morph")
		$$skill("Sonar Imaging", MA, "Esoteric", , "Adv:Sonar Vision")
		$$skill("Yin/Yang Healing", MH, "Esoteric;Medical", "iq-6")
		end
	sublist "Hobby" memlist
		$$skill("Chess", ME, "Hobby", "iq-4;strategy-4")
		$$skill("Darts", PE, "Hobby", "dx-4;throwing")
		$$skill("Kite Flying", PE, "Hobby", "dx-2")
		end
	sublist "Knowledge" memlist
		$$skill("Area Knowledge (Cyberspace)", ME, "Knowledge", "iq-4", , tl/7+)
		$$skill("Area Knowledge (Galaxy)", MH, "Knowledge", "iq-4", , tl/9+)
		$$skill("Bardic Lore", MH, "Knowledge", "iq-6")
		sublist "Hidden Lore" memlist
			$$skill("Hidden Lore", MA, "Knowledge")
			$$skill("Spirit Lore", MA, "Knowledge")
			$$skill("Demon Lore", MA, "Knowledge")
			$$skill("Faerie Lore", MA, "Knowledge")
			$$skill("City Secrets Lore", MA, "Knowledge")
			end
		$$skill("Performance/Ritual", MA, "Knowledge;Social", "iq-5;acting-2;bard-2")
		$$see("Ritual Magic", %-5l!MVH)
		$$skill("Rituals and Ceremonies", MH, "Knowledge", "iq-6", , 0)
		$$skill("Sacrifice", MH, "Knowledge", , "Sk:Theology>=slc(12)")
		$$skill("Skaldic Lore", MH, "Knowledge", "iq-6")
		$$skill("Symbol Drawing", MH, "Artistic;Knowledge;Magical", "ritualmagic-4")
		$$skill("Tea Ceremony", MH, "Knowledge;Social", "iq-6;meditation-2;meditationrealistic-2")
		$$skill	Tournament Law	ME	Martial Arts;Athletic;Knowledge;*Tournament Law	iq-6
		end
	sublist "Medical" memlist
		$$sciskill("Herbalist", MH, "Medical;Scientific", "naturalist-6")
		$$sciskill("Herbary", MA, "Medical;Scientific", , "Sk:Botany>=slc(12)")
		$$sciskill("Herbary (Miraculous)", MVH, "Medical", , "Sk:Botany>=slc(12)")
		$$sciskill(Pharmacy, MH, "Medical", "iq-7", , tl)
		end
	sublist "Military" memlist
		$$skill("Explosive Ordnance Disposal", MH, "Military", "demolition-4", "Main:DX>=12")
		$$skill("SIGINT Collection/Jamming", MH, "Military", , , tl/7+)
		$$skill("Traffic Analysis", MH, "Military", , , tl)
		end
	sublist "Outdoor" memlist
		$$skill("Animal Guise", MA, "Outdoor", "iq-5", , 0)
		$$skill("Bow and Palette", PA, "Outdoor", "dx-5", , 0)
		$$skill("Flint Sparking", PE, "Outdoor", "dx-4", , 0)
		$$skill("Mimicry (Human Speech)", PH, "Outdoor;*Mimicry", "iq-6;ht-6#ht*iq")
		$$skill("Mimicry (Bird Calls)", PH, "Outdoor;*Mimicry", "iq-6;ht-6;mimicryanimalsounds-6#iq*ht")
		$$skill("Mimicry (Animal Sounds)", PH, "Outdoor;*Mimicry", "iq-6;ht-6;mimicrybirdcalls-6#iq*ht")
		$$skill("Open-Dress Diving", MA, "Outdoor", "scuba-2", "Configuration:TL>=5-&tl", tl/5+)
		sublist Survival memlist
			$$skill("Survival (Urban)", MA, "Outdoor;Survival", "iq-5")
			end
		end
	sublist "Professional" memlist
		$$skill("Abacus", MA, "Professional;Scientific")
		$$skill("Aviation", MA, "Professional;Vehicle", "iq-5", , tl/6+)
		$$skill("Bartender", MA, "Professional", "carousing-3")
		$$skill("Courtesan", MA, "Professional", "savoirfaire-5")
		$$skill("Cyberdeck Operation", MVH, "Professional", "computeroperation-8", "Configuration:TL>=8-&tl", tl/8+)
		$$skill("Exorcism", MH, "Professional", "iq-6;theology-3")
		$$skill("Fortune Telling", MA, "Professional;*Empathic", "iq-4;fasttalk-3")
		$$skill("Law Enforcement", MA, "Professional", "iq-5")
		$$skill("Musical Notation", ME, "Professional")
		$$skill("Panhandling", ME, "Professional", "fasttalk-2;bard-3;iq-5")
		$$skill("Sailor", MA, "Professional;Vehicle", "iq-5", , tl)
		$$skill("Soldier", MA, "Professional", "iq-5;tactics-5", , tl)
		$$skill("Shipmaster", MA, "Professional;Vehicle", "iq-5;Astrogation-3;Aviation-4", Conf:TL>=8, tl/8+)
		$$skill("Temporal Operation", MA, "Professional", "temporalelectronics-2", , tl/8+)
		$$skill("Typing", PE, "Professional", "dx-4;law-3", , tl/6+)
			opt exp "Typing Speed (Manual) (wpm)" "x*3"
				exp "Typing Speed (Electric) (wpm)" "x*5"
				end
		end
	sublist "Scientific" memlist
		$$sciskill("Artificial Intelligence", MH, "Scientific;Science", "computerprogramming-3;teaching-5", , tl/7+)
		$$sciskill(Astrology, MH, "Scientific;Science", "iq-6", , tl)
		$$sciskill("Cartography", MA, "Scientific", "iq-5;surveying-5;navigation-5", "!Disadvantages:Non-Iconographic", tl)
		$$sciskill("Conspiracy Theory", MVH, "Scientific", "history-4;occultism-4")
		$$sciskill("Cryptography", MH, "Scientific;Military", "cryptanalysis-5;cryptology-5", , tl)
		$$sciskill("Cryptology", MH, "Scientific;Military", "cryptanalysis-5;cryptography-5", , tl)
		$$sciskill("Cyphering", ME, "Scientific;*Mathematical", "iq-2", "!Adv:Lightning Calculator")
		$$sciskill("History (Esoteric)", MH, "Scientific")
		$$sciskill("Hydrology", MA, "Scientific", "meteorology-6;methology-3", , tl)
		$$sciskill("Methology", MA, "Scientific", "meteorology-8;hydrology-3", , tl)
		$$sciskill("Hyperspace Physics", MVH, "Scientific;Science", , "Sk:Mathematics>=15;Physics>=15;Nuclear Physics>=15", tl/8+)
		$$sciskill("Occultism (Demonology)", MA, "Scientific;Magical;Occult", "iq-6")
		$$sciskill("Occultism (Vampire)", MA, "Scientific;Occult", "iq-6")
		$$sciskill("Oral Literature", MH, "Scientific", "iq-6")
		sublist "Paleontology" memlist
			$$sciskill("Paleontology", MH, "Scientific;Science", "anthropology-5;paleozoology-2;paleobotany-2;paleoanthropology-2;micropaleontology-2")
			$$sciskill("Paleozoology", MH, "Scientific;Science", "zoology-4;paleontology-2;paleobotany-2;paleoanthropology-2;micropaleontology-2")
			$$sciskill("Paleobotany", MH, "Scientific;Science", "botany-3;paleontology-2;paleozoology-2;paleoanthropology-2;micropaleontology-2")
			$$sciskill("Paleoanthropology", MH, "Scientific;Science", "anthropology-2;paleontology-2;paleozoology-2;paleobotany-2;micropaleontology-2")
			$$sciskill("Micropaleontology", MH, "Scientific;Science", "botany-4;biochemistry-3;paleobotany-2;paleoanthropology-2;paleontology-2")
			end
		sublist "Photonics" memlist
			$$sciskill("Photonics", MH, "Scientific;Science;*Photonics", "cat:'Photonics'-4;electronics-4", "Sk:Mathematics>=slc(12)", tl)
			$$sciskill("Photonics (Communications)", MH, "Scientific;Science;*Photonics", "cat:'Photonics'-4;electronicscommunications-4", "Sk:Mathematics>=slc(12)", tl/7+)
			$$sciskill("Photonics (Computers)", MH, "Scientific;Science;*Photonics", "cat:'Photonics'-4;electronicscomputers-4", "Sk:Mathematics>=slc(12)", tl/7+)
			$$sciskill("Photonics (Force Shields)", MH, "Scientific;Science;*Photonics", "cat:'Photonics'-4;electronicsforceshields-4", "Sk:Mathematics>=slc(12)", tl/8+)
			$$sciskill("Photonics (Holographics)", MH, "Scientific;Science;*Photonics", "cat:'Photonics'-4;electronicsholographics-4", "Sk:Mathematics>=slc(12)", tl/8+)
			$$sciskill("Photonics (Matter Transmitters)", MH, "Scientific;Science;*Photonics", "cat:'Photonics'-4;electronicsmattertransmitters-4", "Sk:Mathematics>=slc(12)", tl/8+)
			$$sciskill("Photonics (Medical)", MH, "Scientific;Science;*Photonics", "cat:'Photonics'-4;electronicsmedical-4", "Sk:Mathematics>=slc(12)", tl/8+)
			$$sciskill("Photonics (Security Systems)", MH, "Scientific;Science;*Photonics", "cat:'Photonics'-4;electronicssecuritysystems-4", "Sk:Mathematics>=slc(12)", tl/8+)
			$$sciskill("Photonics (Sensors)", MH, "Scientific;Science;*Photonics", "cat:'Photonics'-4;electronicssensors-4", "Sk:Mathematics>=slc(12)", tl/7+)
			$$sciskill("Photonics (Weapons)", MH, "Scientific;Science;*Photonics", "cat:'Photonics'-4;electronicsweapons-4", "Sk:Mathematics>=slc(12)", tl/7+)
			end
		$$sciskill("Probability Physics", MVH, "Scientific;Science", , "Sk:Mathematics>=15;Sk:Physics>=15;Sk:Nuclear Physics>=15")
		$$sciskill("Paraphysics", MVH, "Scientific;Psionic", , "Physics>=slc(12);Biochemistry>=slc(12)", tl)
		$$sciskill("Psionics", MVH, "Scientific;Science;Psionic", , , tl)
		$$sciskill("Science!", MVH, "Scientific", , "Sk:Research>=13;#2,Sk:Science", tl)
		$$sciskill("Speed-Reading", MA, "Scientific", , "Adv:Literacy|Configuration:TL>=4-&tl")
		$$sciskill("Surveying", MA, "Scientific;Outdoor", "iq-5;cartography-5;navigation-5", "Sk:Mathematics>=slc(12)", tl)
		sublist "Electronics" memlist
			$$sciskill("Temporal Electronics", MH, "Scientific;Science", "temporaloperation-6;electronics-5", "Sk:Temporal Physics>=slc(12)", tl/8+)
			end
		$$sciskill("Temporal Physics", MVH, "Scientific;Science", "temporalelectronics-6;physics-4", "Sk:Physics>=slc(12);Configuration:TL>=9-&tl", tl/9+)
		$$sciskill("Thanatology", MH, "Scientific", "diagnosis-5;psychology-5;mortician-3")
		$$sciskill("Thaumatology", "MVH", "Magical;Scientific;Science", "iq-6")
		$$sciskill("Weather Sense", MA, "Scientific", "iq-5;meteorology+0")
		$$sciskill("Weird Magic", MVH, "Magical;Scientific")
		$$sciskill("Weird Science", MVH, "Scientific;Science")
		end
	sublist "Social" memlist
		$$skill("Erotic Art", PH, "Social", "acrobatics-5", "Sk:Sex Appeal>=13")
		$$skill("Savoir-Faire (Dojo)", ME, "Social;*Empathic;*Savoir-Faire", "iq-4;cat:'Tournament Law'-3")
		$$skill("Savoir-Faire (Military)", ME, "Social;*Empathic;*Savoir-Faire", "iq-4")
		$$skill("Savoir-Faire (Servant)", ME, "Social;*Empathic;*Savoir-Faire", "iq-4;savoirfaire-2")
		end
	sublist "Thief/Spy" memlist
		$$skill("Brain Hacking", MVH, "Thief/Spy", "iq+will-6", "Sk:Psychology>=slc(12)")
		$$skill("Filch", PA, "Thief/Spy;*Manual", "pickpocket-5;sleightofhand-5")
		$$skill("Starglazing", PE, "Thief/Spy", "dx-4;lockpicking-4")
		$$skill("Uttering of Base Coin", MH, "Thief/Spy", "forgery-2", , tl)
		end
	sublist "Vehicle" memlist
		$$skill("Airshipman", MH, "Vehicle", "iq-6", , tl/6+)
		$$skill("Shiphandling", MH, "Vehicle", "iq-6", "Sk:Meteorology>=slc(12);Navigation>=slc(12);Seamanship>=slc(12)", tl)
		$$skill("Shiphandling (Starship)", MH, "Vehicle", "iq-6", "Astrogation>=slc(12);Piloting (Starship)>=slc(12);Shipmaster>=slc(12);Configuration:TL>=8-&tl", tl/8+)
		end
	sublist "Magic College Skills" memlist
		$$csp("Animal College")
		$$csp("Body Control College")
		$$csp("Communication and Empathy College")
		$$csp("Earth College")
		$$csp("Air College")
		$$csp(Weather College)
		$$csp(Electricity College)
		$$csp("Fire College")
		$$csp("Water College")
		$$csp("Ice College")
		$$csp("Acid College")
		$$csp("Enchantment College")
		$$csp(Food College)
		$$csp("Gate College")
		$$csp("Healing College")
		$$csp("Illusion and Creation College")
		$$csp("Knowledge College")
		$$csp("Light and Darkness College")
		$$csp("Making and Breaking College")
		$$csp("Meta-Spell College")
		$$csp("Mind Control College")
		$$csp("Movement College")
		$$csp("Necromantic College")
		$$csp("Plant College")
		$$csp("Protection and Warning College")
		$$csp("Sound College")
		$$csp(Technological College)
		$$csp("Machine College")
		$$csp("Energy College")
		$$csp("Radiation College")
		$$csp("Metal/Plastic College")
		end
	end

cat "Powers"
	sublist "Natural Attacks" memlist
		$$natatt("Breathe Fire", "Jet", DX, 20, 3, , , 1d, fire)
		$$natatt("Cool", "Area", , 15, , 3-hex radius)
			opt percent "Turn On and Off at Will" "?+0;+10%" end
		$$natatt("Dampen", "Ranged", IQ, 15, , 3-hex radius, While concentrating)
		$$natatt("Deafen", "Ranged", DX, 15, , 3-hex radius, 3min)
		$$natatt(Flash, Area, DX, 15, , 2-hex radius)
		$$natatt	Image	Ranged	IQ	20	3		While concentrating
		$$natatt	Laser	Ranged	DX	25	12			1d-1	imp
			opt percent "Can Flash" "?+0;+25%"
				percent "Costs 2 Fatigue" "?+0;-10%"
				end
		$$natatt	Lightning	Missile	DX	20	6			1d	electrical
		$$natatt	Shock	Close Combat	DX	20				1d	electrical
		$$natatt	Smoke	Area		15		3 hexes
			opt	percent "See through Own Smoke" "?+0;+20%" end
		$$natatt	Sonic Blast	Ranged	DX	20	6			1d	sonic
		$$natatt("Surge", "Ranged", IQ, 15, 3)
		$$natatt	Warm	Area		15		3-hex radius
			opt percent "Turn On and Off at Will" "?+0;+10%" end
		end
	end


cat "Quirks"
	sublist "Alcohol-Related Quirks" memlist
		$$q(Alcohol Intolerance)
		$$q(Horrible Hangovers)
		$$q(Nervous Stomach)
		$$q(Obnoxious Drunk)
		$$q(Personality Change When Drunk)
		$$q(Sleepy Drinker)
		end
	sublist "Personality" memlist
		$$q(Attentive)
		$$q(Broad-Minded)
		$$q(Careful)
		$$q(Chauvinistic)
		$$q(Congenial)
		$$q(Distractible)
		$$q(Dreamer)
		$$q(Dull)
		$$q(Humble)
		$$q(Imaginative)
		$$q(Nosy)
		$$q(Proud)
		$$q(Responsive)
		$$q(Staid)
		$$q(Uncongenial)
		$$q(Undiscriminating)
		end
	end

options
	list Advantages
		mult "Favor" *1/5
		list Patron
			add "Secret" -5
			end
		list Familiar
			mult "Limited Range" 1/2
			mult "Limited Time" "?:3;1/4;1/3;1/2;2/3;3/4"
			mult "Erratic Powers" "?:1;8 or less,1/3;10 or less,1/2;12 or less,3/4)"
			end
		list "Multiple Forms"
			begin text "File Name" "" editdlg 1 end
			end
		list Knack
			mult "Doesn't require touch" *2
			end
		end
	list "Racial Bonuses"
		begin adj "Racial Height" b_height+x;max_height+x ??0 noprint dispexp "format('l: %s',dispInch(o))" end
		begin adj "Racial Weight" b_weight+x ??0 noprint dispexp "format('l: %s',dw(o))" end
		percent "No Jumping Bonus" "?+0;-5%"
		percent "No Fatigue Bonus" "?+0;-30%"
		percent "Doesn't Affect Skills" "?+0;-5%"
		percent "No Fine Manipulators" "?+1;-40%"
		begin adj "Skill Name" "\"Skills:x\"+@v@" "" selitem *Skills noprint keepold end
		end
	list Disadvantages
		list Enemy
			add "Unknown" -5
			end
		end
	list Advantages
		list Contacts
			mult Available "?:2;Rarely (6-), 1/2;Fairly often (9-), 1;Quite often (12-), 2;Always (15-), 3"
			mult Reliable "?:2;Not, 1/2;Somewhat, 1;Usually, 2;Completely, 3"
			end
		end
	list "Super Enhancements"
		begin percent Accuracy "??1;5;x*5;x>0;Must be > 0"
			dispexp "'l: +t, +o%'"
			end
		percent "Affects Insubstantial" +20%
		percent "Affects Others" +40%
		percent "Affects Substantial" +40%
		begin percent "Area Effect" +50% dispexp "format('l: o%% (%d)',max(1,integer(`Power`/5))+`Increased Area`/20)" end
		percent "Armor Piercing" "?:1;3/4 eff. DR,+50%;1/2 eff. DR,+100%"
		percent "Continuing Damage" "?:1;+50%;Full Duration,+100%"
		percent "Continuous Beam" +50%
		percent Cutting +25%
		percent "Delay" "?:1;2 sec,+20%;1-10 sec,+40%"
		percent "Doesn't Harm User" +20%
		percent "Explosive Effect" +40%
		begin percent "Extended Duration" "??1;30;x*30;x>0" dispexp "format('l: %d, +o%%',2^(o/30))" end
		begin percent Fan "??1;10;x*10;x>0;Must be > 0"
			dispexp "'l: +t width, +o%'"
			end
		begin percent Homing "??1;50;x*50;x>0;Must be > 0"
			dispexp "'l: t, +o%'"
			end
		percent Hotshot +30%
		percent Impaling +40%
		begin percent "Increased Area" "??1;20;x*20;x>0;Must be > 0"
			dispexp "'l: +t, +o%'"
			end
		begin percent "Increased Knockback" "??1;20;x*20;x>0"
			dispexp "'l: t, +o%'"
			end
		percent Instantaneous +20%
		percent "Link" "?:1;Permanent,+10%;Can be used separately,+20%"
		percent "Moveable Area" +40%
		percent "No Obvious Effect" +20%
		percent Paste +10%
		begin percent "Rapid Fire" "??1;40;x*40;x>0;Must be > 0"
			dispexp "'l: t, +o%'"
			end
		begin percent "Reduced Fatigue Cost" "??1;20;x*20;x>0;Must be > 0"
			dispexp "'l: -t/turn, +o%'"
			end
		begin percent Ricochet "??1;20;x*20;x>0;Must be > 0"
			dispexp "'l: t, +o%'"
			end
		percent "Selective Effect" +50%
		percent Stunning +10%
		percent Wall "Linear,+30%;Any Shape,+60%"
		list "Insubstantiality"
			percent "Turn Held Object (In)substantial" +100%
			percent "Turn Parts of Body (In)substantial" +20%
			percent "Can Affect Substantial" +100%
			end
		end
	list "Super Limitations"
		begin percent "Accessibility" "??10;-10;-x;x>0"
			dispexp "'l: o%'"
			end
		percent "Always On" "?:1;Minor Inconvenience,-10%;Significant Inconvenience,-20%;Major Inconvenience,-40%"
		percent "Differential Effect" -10%
		percent "Emergencies Only" -30%
		percent Exclusivity -10%
		percent "Eye Contact Only" -20%
		percent "Fatigue Cost" "?:1;1,-5%;2,-10%;3,-15%4,-20%;5,-25%;6,-30%;7,-35%;8,-40%;9,-45%;10,-50%"
		percent "Fatigue Damage Only" -20%
		percent "Fickle" "?:1;14 or less,-10%;11 or less,-20%;8 or less,-30%;5 or less,-70%"
		percent "Full Power Only" -10%
		percent "Knockback Only" -40%
		percent "Leaves Mental Signature" -10%
		percent "Limited Use" "?:1;1/day,-40%;2/day,-30%;3/day,-20%;4/day,-20%;5/day,-10%;6/day,-10%"
		percent "Night Only" -20%
		percent "No Knockback" -10%
		percent "Nuisance Effect" -10%
		percent "Only in Altered Body Form" -10%
		percent "Only when Flying" -30%
		percent Recoil -40%
		begin percent "Reduced Range" "??1;-5;x*-5;x>0 and x<4;Must be between 1/2 and 1/8" dispexp "format('l: 1/%d, %d%%',2^t,o)" end
		percent "Requires Preparation" "?:1;1 min.,-20%;10 min.,-30%;1 hr.,-50%;8 hrs.,-60%"
		percent "Resisted by" "?:1;DX,-20%;HT,-20%;IQ,-20%;ST,-20%;Will,-20%"
		percent "Stun Damage Only" -20%
		percent "Takes Extra Time" "?:1;2,-10%;4,-20%;8,-30%;16,-40%;32,-50%"
		percent "Takes Recharge" "?:1;5 sec,-10%;15 sec,-20%;1 hour,-30%"
		percent "Touch Only" -20%
		percent "Unconscious Only" -20%
		percent Uncontrollable -30%
		percent "Unreliable" "?:1;14 or less,-10%;11 or less,-20%;8 or less,-30%;5 or less,-70%"
		percent "Weakened Without Preparation" "?:1;1 min.,-10%;10 min.,-15%;1 hr.,-25%;8 hrs.,-30%"
		end
	list "Eyes"
		percent "Eyestalks" -20%
		# This can be applied to 360-Degree Vision or racial Peripheral Vision
		end
	list "Natural Attacks"
		text "Cheap Improvement Scheme" "Yes"
		end
	end
end
